/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.ui.core;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.core.ChromatogramSubtractor;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.xxd.ui.dialogs.ChromatogramEditorDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramFilter
extends AbstractChromatogramFilter {
    public IProcessingInfo applyFilter(final IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages()) {
            Shell shell = DisplayUtils.getShell();
            if (shell != null) {
                this.subtractChromatogram(shell, chromatogramSelection);
            } else {
                DisplayUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = new Shell();
                        shell.setSize(0, 0);
                        shell.open();
                        ChromatogramFilter.this.subtractChromatogram(shell, chromatogramSelection);
                        shell.close();
                    }
                });
            }
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram was successfully subtracted."));
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ChromatogramFilterSettings filterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }

    private void subtractChromatogram(Shell shell, IChromatogramSelection chromatogramSelectionMaster) {
        IChromatogramSelection chromatogramSelectionSubtract;
        IChromatogram chromatogramMaster = chromatogramSelectionMaster.getChromatogram();
        ChromatogramEditorDialog dialog = new ChromatogramEditorDialog(shell, chromatogramMaster);
        if (dialog.open() == 0 && (chromatogramSelectionSubtract = dialog.getChromatogramSelection()) != null) {
            IChromatogram chromatogramSubtract = chromatogramSelectionSubtract.getChromatogram();
            if (chromatogramMaster != chromatogramSubtract) {
                int startRetentionTime = chromatogramSelectionMaster.getStartRetentionTime();
                int stopRetentionTime = chromatogramSelectionMaster.getStopRetentionTime();
                ChromatogramSubtractor chromatogramSubtractor = new ChromatogramSubtractor();
                chromatogramSubtractor.perform(chromatogramMaster, chromatogramSubtract, startRetentionTime, stopRetentionTime);
            } else {
                MessageDialog.openWarning((Shell)shell, (String)"Subtract Chromatogram", (String)"The following chromatogram has been selected for subtraction.");
            }
        }
    }
}

