/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.PeakFilter;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.PeakFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class FilterRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "SNIP Filter Peak";
    private static final String FILTER_ID_PEAK = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.snip.peak";
    private IChromatogramSelectionMSD chromatogramSelectionMSD;
    private boolean useSelectedPeak = true;

    public FilterRunnable(IChromatogramSelectionMSD chromatogramSelectionMSD, boolean useSelectedPeak) {
        this.chromatogramSelectionMSD = chromatogramSelectionMSD;
        this.useSelectedPeak = useSelectedPeak;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            PeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
            IProcessingInfo processingInfo = this.useSelectedPeak ? PeakFilter.applyFilter((IPeakMSD)((IPeakMSD)this.chromatogramSelectionMSD.getSelectedPeak()), (IPeakFilterSettings)peakFilterSettings, (String)FILTER_ID_PEAK, (IProgressMonitor)monitor) : PeakFilter.applyFilter((IChromatogramSelectionMSD)this.chromatogramSelectionMSD, (IPeakFilterSettings)peakFilterSettings, (String)FILTER_ID_PEAK, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            this.updateSelection();
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FilterRunnable.this.chromatogramSelectionMSD.update(true);
            }
        });
    }
}

