/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.Activator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.settings.FilterSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_IONS_TO_REMOVE = "ionsToRemove";
    public static final String P_IONS_TO_PRESERVE = "ionsToPreserve";
    public static final String P_SEGMENT_WIDTH = "segmentWidth";
    public static final String P_ADJUST_THRESHOLD_TRANSITIONS = "adjustThresholdTransitions";
    public static final String P_NUMBER_OF_USE_IONS_FOR_COEFFICIENT = "numberOfUsedIonsForCoefficient";
    public static final String DEF_IONS_TO_REMOVE = "18;28;84;207";
    public static final String DEF_IONS_TO_PRESERVE = "103;104";
    public static final int DEF_NUMBER_OF_USE_IONS_FOR_COEFFICIENT = 1;
    public static final int DEF_SEGMENT_WIDTH = 13;
    public static final int SEGMENT_WIDTH_MIN = 5;
    public static final int SEGMENT_WIDTH_MAX = 19;
    public static final int NUMBER_OF_USE_IONS_FOR_COEFFICIENT_MIN = 1;
    public static final int NUMBER_OF_USE_IONS_FOR_COEFFICIENT_MAX = 20;
    public static final boolean DEF_USE_CHROMATOGRAM_SPECIFIC_IONS = false;
    public static final boolean DEF_ADJUST_THRESHOLD_TRANSITIONS = true;
    private static final Logger logger = Logger.getLogger(PreferenceSupplier.class);
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
        defaultValues.put(P_IONS_TO_PRESERVE, DEF_IONS_TO_PRESERVE);
        defaultValues.put(P_SEGMENT_WIDTH, Integer.toString(13));
        defaultValues.put(P_ADJUST_THRESHOLD_TRANSITIONS, Boolean.toString(true));
        defaultValues.put(P_NUMBER_OF_USE_IONS_FOR_COEFFICIENT, Integer.toString(1));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static FilterSettings getFilterSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        FilterSettings filterSettings = new FilterSettings();
        filterSettings.setAdjustThresholdTransitions(preferences.getBoolean(P_ADJUST_THRESHOLD_TRANSITIONS, true));
        filterSettings.setNumberOfUsedIonsForCoefficient(preferences.getInt(P_NUMBER_OF_USE_IONS_FOR_COEFFICIENT, 1));
        filterSettings.setIonsToRemove(preferences.get(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        filterSettings.setIonsToPreserve(preferences.get(P_IONS_TO_PRESERVE, DEF_IONS_TO_PRESERVE));
        filterSettings.setSegmentWidth(preferences.getInt(P_SEGMENT_WIDTH, 13));
        return filterSettings;
    }

    public static void setMarkedIons(IMarkedIons markedIons, Set<Integer> ions) {
        for (int ion : ions) {
            markedIons.add((Object)new MarkedIon((double)ion));
        }
    }

    public static Set<Integer> getIons(String preference, String def) {
        String[] items;
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        HashSet<Integer> ions = new HashSet<Integer>();
        String preferenceEntry = preferences.get(preference, def);
        if (preferenceEntry != "" && (items = PreferenceSupplier.parseString(preferenceEntry)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    Integer ion = Integer.parseInt(item);
                    ions.add(ion);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
                ++n2;
            }
        }
        return ions;
    }

    public static String[] parseString(String stringList) {
        String[] decodedArray;
        if (stringList.contains(";")) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringList, ";");
            int arraySize = stringTokenizer.countTokens();
            decodedArray = new String[arraySize];
            int i = 0;
            while (i < arraySize) {
                decodedArray[i] = stringTokenizer.nextToken(";");
                ++i;
            }
        } else {
            decodedArray = new String[]{stringList};
        }
        return decodedArray;
    }

    public static String createList(String[] items) {
        String ions = "";
        if (items != null) {
            int size = items.length;
            int i = 0;
            while (i < size) {
                ions = ions.concat(String.valueOf(items[i]) + ";");
                ++i;
            }
        }
        return ions;
    }

    public static boolean adjustThresholdTransitions() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_ADJUST_THRESHOLD_TRANSITIONS, true);
    }

    public static Set<Integer> getIonsToRemove() {
        return PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
    }

    public static Set<Integer> getIonsToPreserve() {
        return PreferenceSupplier.getIons(P_IONS_TO_PRESERVE, DEF_IONS_TO_PRESERVE);
    }

    public static int getSegmentWidth() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_SEGMENT_WIDTH, 13);
    }
}

