/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramExportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramExportRunnable.class);
    private File data;
    private File file;
    private IChromatogramCSD chromatogram;
    private ISupplier supplier;

    public ChromatogramExportRunnable(File file, IChromatogramCSD chromatogram, ISupplier supplier) {
        this.file = file;
        this.chromatogram = chromatogram;
        this.supplier = supplier;
    }

    public File getData() {
        return this.data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IProcessingInfo processingInfo = ChromatogramConverterCSD.getInstance().convert(this.file, (IChromatogram)this.chromatogram, this.supplier.getId(), monitor);
            this.data = (File)processingInfo.getProcessingResult();
        }
        finally {
            monitor.done();
        }
    }
}

