/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramImportRunnable.class);
    private File file;
    private ChromatogramSelectionCSD chromatogramSelection;

    public ChromatogramImportRunnable(File file, ChromatogramSelectionCSD chromatogramSelection) {
        this.file = file;
        this.chromatogramSelection = chromatogramSelection;
    }

    public ChromatogramSelectionCSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Chromatogram", -1);
                IProcessingInfo processingInfo = ChromatogramConverterCSD.getInstance().convert(this.file, monitor);
                IChromatogramCSD chromatogram = (IChromatogramCSD)processingInfo.getProcessingResult();
                this.chromatogramSelection = new ChromatogramSelectionCSD(chromatogram);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

