/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.ChromatogramFilterSupplierWSD;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.ChromatogramFilterSupportWSD;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.IChromatogramFilterSupportWSD;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.chromatogram.IChromatogramFilterWSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramFilterWSD {
    private static final Logger logger = Logger.getLogger(ChromatogramFilterWSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.wsd.filter.chromatogramFilterSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILTER = "filter";
    private static final String FILTER_SETTINGS = "filterSettings";
    private static final String PROCESSING_DESCRIPTION = "Chromatogram Filter";
    private static final String NO_CHROMATOGRAM_FILTER_AVAILABLE = "There is no chromatogram filter available.";

    private ChromatogramFilterWSD() {
    }

    public static IProcessingInfo applyFilter(IChromatogramSelectionWSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IChromatogramFilterWSD chromatogramFilter = ChromatogramFilterWSD.getChromatogramFilter(filterId);
        if (chromatogramFilter != null) {
            processingInfo = chromatogramFilter.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyFilter(IChromatogramSelectionWSD chromatogramSelection, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IChromatogramFilterWSD chromatogramFilter = ChromatogramFilterWSD.getChromatogramFilter(filterId);
        if (chromatogramFilter != null) {
            processingInfo = chromatogramFilter.applyFilter(chromatogramSelection, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_CHROMATOGRAM_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IChromatogramFilterSupportWSD getChromatogramFilterSupport() {
        IConfigurationElement[] extensions;
        ChromatogramFilterSupportWSD filterSupport = new ChromatogramFilterSupportWSD();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramFilterSupplierWSD supplier = new ChromatogramFilterSupplierWSD();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            if (element.getAttribute(FILTER_SETTINGS) != null) {
                try {
                    IChromatogramFilterSettings instance = (IChromatogramFilterSettings)element.createExecutableExtension(FILTER_SETTINGS);
                    supplier.setFilterSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                    supplier.setFilterSettingsClass(null);
                }
            }
            filterSupport.add(supplier);
            ++n2;
        }
        return filterSupport;
    }

    private static IChromatogramFilterWSD getChromatogramFilter(String filterId) {
        IConfigurationElement element = ChromatogramFilterWSD.getConfigurationElement(filterId);
        IChromatogramFilterWSD instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramFilterWSD)element.createExecutableExtension(FILTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

