/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.runnables;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.core.support.Identifier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.INistSettings;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PeakListIdentifierGUIRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(PeakListIdentifierGUIRunnable.class);
    private static final String DESCRIPTION = "NIST GUI Peak List Identifier";
    private IChromatogramSelectionMSD chromatogramSelection;

    public PeakListIdentifierGUIRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            PeakIdentifierSettings peakIdentifierSettings = PreferenceSupplier.getPeakIdentifierSettings();
            List peaks = this.chromatogramSelection.getChromatogramMSD().getPeaks();
            ArrayList<IChromatogramPeakMSD> peakList = new ArrayList<IChromatogramPeakMSD>();
            for (IChromatogramPeakMSD chromatogramPeak : peaks) {
                peakList.add(chromatogramPeak);
            }
            try {
                Identifier identifier = new Identifier();
                identifier.openNistForPeakIdentification(peakList, (INistSettings)peakIdentifierSettings, monitor);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

