/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.support.LibraryInformationSupport;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MassSpectrumListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;
    private LibraryInformationSupport libraryInformationSupport = new LibraryInformationSupport();

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = ".*" + searchText + ".*";
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.matchElement(element);
    }

    public boolean matchElement(Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof ILibraryMassSpectrum) {
            ILibraryMassSpectrum libraryMassSpectrum = (ILibraryMassSpectrum)element;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            if (this.libraryInformationSupport.matchSearchText(libraryInformation, this.searchText, this.caseSensitive)) {
                return true;
            }
        } else if (element instanceof IScanMSD) {
            IScanMSD massSpectrum = (IScanMSD)element;
            for (IIdentificationTarget massSpectrumTarget : massSpectrum.getTargets()) {
                IIdentificationTarget identificationEntry = massSpectrumTarget;
                ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
                if (!this.libraryInformationSupport.matchSearchText(libraryInformation, this.searchText, this.caseSensitive)) continue;
                return true;
            }
        }
        return false;
    }
}

