/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.peak;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.IPeakIdentifierSupportMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierSupplierMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierSupportMSD;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.IIdentificationResults;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakIdentifierMSD {
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.identifier.peakIdentifier";
    private static final Logger logger = Logger.getLogger(PeakIdentifierMSD.class);
    private static final String NO_IDENTIFIER_AVAILABLE = "There is no suitable peak identifier available";

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static <T> IProcessingInfo<T> getNoIdentifierAvailableProcessingInfo() {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Identifier", NO_IDENTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }

    private static <T extends IIdentificationResults> IPeakIdentifierMSD<T> getPeakIdentifier(String identifierId) {
        IConfigurationElement element = PeakIdentifierMSD.getConfigurationElement(identifierId);
        IPeakIdentifierMSD instance = null;
        if (element != null) {
            try {
                instance = (IPeakIdentifierMSD)element.createExecutableExtension("identifier");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    public static IPeakIdentifierSupportMSD getPeakIdentifierSupport() {
        IConfigurationElement[] extensions;
        PeakIdentifierSupportMSD identifierSupport = new PeakIdentifierSupportMSD();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakIdentifierSupplierMSD supplier = new PeakIdentifierSupplierMSD();
            supplier.setId(element.getAttribute("id"));
            supplier.setDescription(element.getAttribute("description"));
            supplier.setIdentifierName(element.getAttribute("identifierName"));
            if (element.getAttribute("identifierSettings") != null) {
                try {
                    IPeakIdentifierSettingsMSD instance = (IPeakIdentifierSettingsMSD)element.createExecutableExtension("identifierSettings");
                    supplier.setIdentifierSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                    supplier.setIdentifierSettingsClass(null);
                }
            }
            identifierSupport.add(supplier);
            ++n2;
        }
        return identifierSupport;
    }

    public static <T> IProcessingInfo<T> identify(IChromatogramPeakMSD peak, IPeakIdentifierSettingsMSD identifierSettings, String identifierId, IProgressMonitor monitor) {
        return PeakIdentifierMSD.identify(peak, identifierSettings, identifierId, monitor);
    }

    public static <T extends IIdentificationResults> IProcessingInfo<T> identify(IPeakMSD peak, String identifierId, IProgressMonitor monitor) {
        return PeakIdentifierMSD.identify(Collections.singletonList(peak), identifierId, monitor);
    }

    public static <T extends IIdentificationResults> IProcessingInfo<T> identify(List<? extends IPeakMSD> peaks, IPeakIdentifierSettingsMSD identifierSettings, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierMSD<T> peakIdentifier = PeakIdentifierMSD.getPeakIdentifier(identifierId);
        if (peakIdentifier != null) {
            return peakIdentifier.identify(peaks, identifierSettings, monitor);
        }
        return PeakIdentifierMSD.getNoIdentifierAvailableProcessingInfo();
    }

    public static <T extends IIdentificationResults> IProcessingInfo<T> identify(List<? extends IPeakMSD> peaks, String identifierId, IProgressMonitor monitor) {
        return PeakIdentifierMSD.identify(peaks, null, identifierId, monitor);
    }

    public static <T extends IIdentificationResults> IProcessingInfo<T> identify(IChromatogramSelectionMSD chromatogramSelectionMSD, String identifierId, IProgressMonitor monitor) {
        return PeakIdentifierMSD.identify(chromatogramSelectionMSD, null, identifierId, monitor);
    }

    public static <T extends IIdentificationResults> IProcessingInfo<T> identify(IChromatogramSelectionMSD chromatogramSelectionMSD, IPeakIdentifierSettingsMSD peakIdentifierSettingsMSD, String identifierId, IProgressMonitor monitor) {
        return PeakIdentifierMSD.identify(((IChromatogramMSD)chromatogramSelectionMSD.getChromatogram()).getPeaks((IRetentionTimeRange)chromatogramSelectionMSD), peakIdentifierSettingsMSD, identifierId, monitor);
    }

    private PeakIdentifierMSD() {
    }
}

