/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.chemclipse.processing.DataCategory;

public final class DataCategoryGroup {
    private final String name;
    private final Set<DataCategory> dataCategories;
    private static final DataCategoryGroup[] DEFAULT_GROUPS = new DataCategoryGroup[]{new DataCategoryGroup("Chromatography", DataCategory.CSD, DataCategory.MSD, DataCategory.WSD), new DataCategoryGroup("Spectroscopy", DataCategory.FID, DataCategory.NMR)};

    public DataCategoryGroup(String name, DataCategory ... dataCategories) {
        this(name, Arrays.asList(dataCategories));
    }

    public DataCategoryGroup(String name, Collection<DataCategory> dataCategories) {
        this.name = name;
        this.dataCategories = Collections.unmodifiableSet(new LinkedHashSet<DataCategory>(dataCategories));
    }

    public String getName() {
        return this.name;
    }

    public Set<DataCategory> getDataCategories() {
        return this.dataCategories;
    }

    public static DataCategoryGroup[] defaultGroups() {
        return (DataCategoryGroup[])DEFAULT_GROUPS.clone();
    }
}

