/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.supplier;

import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class NodeProcessorPreferences<T>
implements ProcessorPreferences<T> {
    private static final String KEY_USE_SYSTEM_DEFAULTS = "useSystemDefaults";
    private static final String KEY_USER_SETTINGS = "userSettings";
    private static final String KEY_ASK_FOR_SETTINGS = "askForSettings";
    private Preferences node;
    private IProcessSupplier<T> supplier;

    public NodeProcessorPreferences(IProcessSupplier<T> supplier, Preferences node) {
        this.supplier = supplier;
        this.node = node;
    }

    @Override
    public ProcessorPreferences.DialogBehavior getDialogBehaviour() {
        if (this.supplier.getSettingsClass() == null) {
            return ProcessorPreferences.DialogBehavior.NONE;
        }
        this.trySync();
        boolean askForSettings = this.node.getBoolean(KEY_ASK_FOR_SETTINGS, true);
        if (askForSettings) {
            return ProcessorPreferences.DialogBehavior.SHOW;
        }
        return ProcessorPreferences.DialogBehavior.SAVED_DEFAULTS;
    }

    public void trySync() {
        try {
            this.node.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public void setAskForSettings(boolean askForSettings) {
        this.node.putBoolean(KEY_ASK_FOR_SETTINGS, askForSettings);
        this.tryFlush();
    }

    private void tryFlush() {
        try {
            this.node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public void setUserSettings(String settings) {
        this.node.put(KEY_USER_SETTINGS, settings);
        this.tryFlush();
    }

    @Override
    public void reset() {
        try {
            this.node.clear();
            this.tryFlush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public boolean isUseSystemDefaults() {
        if (this.supplier.getSettingsClass() == null) {
            return true;
        }
        this.trySync();
        return this.node.getBoolean(KEY_USE_SYSTEM_DEFAULTS, true);
    }

    @Override
    public void setUseSystemDefaults(boolean useSystemDefaults) {
        this.node.putBoolean(KEY_USE_SYSTEM_DEFAULTS, useSystemDefaults);
        this.tryFlush();
    }

    @Override
    public String getUserSettingsAsString() {
        this.trySync();
        return this.node.get(KEY_USER_SETTINGS, "");
    }

    @Override
    public IProcessSupplier<T> getSupplier() {
        return this.supplier;
    }
}

