/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.supplier;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProcessExecutionContext
implements ProcessSupplierContext,
MessageConsumer {
    private static final int WORK_UNIT = 100;
    private final SubMonitor subMonitor;
    private final ProcessSupplierContext context;
    private final MessageConsumer consumer;
    private ProcessExecutionContext parent;
    private final Map<Class<?>, Object> contextMap = new IdentityHashMap();

    public ProcessExecutionContext(IProgressMonitor monitor, MessageConsumer rootConsumer, ProcessSupplierContext rootContext) {
        this(monitor, rootConsumer, rootContext, null);
    }

    private ProcessExecutionContext(IProgressMonitor monitor, MessageConsumer rootConsumer, ProcessSupplierContext rootContext, ProcessExecutionContext parent) {
        this.consumer = rootConsumer;
        this.context = rootContext;
        this.parent = parent;
        this.subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.subMonitor;
    }

    public ProcessExecutionContext getParent() {
        return this.parent;
    }

    public <T> ProcessExecutionContext getParent(Class<T> clazz, Predicate<T> predicate) {
        if (this.parent != null) {
            T contextObject = this.parent.getContextObject(clazz);
            if (predicate.test(contextObject)) {
                return this.parent;
            }
            return this.parent.getParent(clazz, predicate);
        }
        return this.parent;
    }

    @Override
    public void addMessage(String description, String message, String details, Throwable t, MessageType type) {
        this.consumer.addMessage(description, message, details, t, type);
    }

    @Override
    public <T> IProcessSupplier<T> getSupplier(String id) {
        IProcessSupplier supplier = this.context.getSupplier(id);
        if (supplier == null && this.parent != null) {
            return this.parent.getSupplier(id);
        }
        return supplier;
    }

    @Override
    public void visitSupplier(Consumer<? super IProcessSupplier<?>> consumer) {
        this.context.visitSupplier(consumer);
        if (this.parent != null) {
            this.parent.visitSupplier(consumer);
        }
    }

    public void setWorkRemaining(int workRemaining) {
        this.subMonitor.setWorkRemaining(workRemaining * 100);
    }

    public ProcessExecutionContext split() {
        return this.split(this.context);
    }

    public ProcessExecutionContext split(ProcessSupplierContext childContext) {
        return new ProcessExecutionContext((IProgressMonitor)this.subMonitor.split(100), this.consumer, childContext, this);
    }

    public <T> T setContextObject(Class<T> type, T object) {
        if (object == null) {
            return (T)this.contextMap.remove(type);
        }
        return (T)this.contextMap.put(type, object);
    }

    public <T> T getContextObject(Class<T> type) {
        Object object = this.contextMap.get(type);
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        if (this.parent != null) {
            return this.parent.getContextObject(type);
        }
        return null;
    }
}

