/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.AbstractMassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier.FileIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumIdentifierFile
extends AbstractMassSpectrumIdentifier {
    public IProcessingInfo<IMassSpectra> identify(List<IScanMSD> massSpectraList, IMassSpectrumIdentifierSettings identifierSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        MassSpectrumIdentifierSettings massSpectrumIdentifierSettings = identifierSettings instanceof MassSpectrumIdentifierSettings ? (MassSpectrumIdentifierSettings)identifierSettings : PreferenceSupplier.getMassSpectrumIdentifierSettings();
        try {
            FileIdentifier fileIdentifier = new FileIdentifier();
            IMassSpectra massSpectra = fileIdentifier.runIdentification(massSpectraList, massSpectrumIdentifierSettings, monitor);
            processingInfo.setProcessingResult((Object)massSpectra);
            processingInfo.addInfoMessage("File Identifier", "Mass spectra have been identified.");
        }
        catch (FileNotFoundException e) {
            processingInfo.addErrorMessage("File Identifier", "An I/O error ocurred.");
        }
        return processingInfo;
    }
}

