/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.core.AbstractPeak;
import org.eclipse.chemclipse.model.core.Classifiable;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.IPeakComparisonResult;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class PeakScanListLabelProvider
extends AbstractChemClipseLabelProvider
implements ITableFontProvider {
    public static final String NAME = "Name";
    public static final String ACTIVE_FOR_ANALYSIS = "Active for Analysis";
    public static final String TYPE = "Type";
    public static final String RETENTION_TIME = "RT [min]";
    public static final String RELATIVE_RETENTION_TIME = "RRT [min]";
    public static final String RETENTION_INDEX = "RI";
    public static final String AREA_TOTAL = "Area";
    public static final String START_RETENTION_TIME = "Start RT [min]";
    public static final String STOP_RETENTION_TIME = "Stop RT [min]";
    public static final String WIDTH = "Width";
    public static final String SCAN_NUMBER_AT_PEAK_MAX = "Scan# at Peak Maximum";
    public static final String SIGNAL_TO_NOISE = "S/N";
    public static final String LEADING = "Leading";
    public static final String TAILING = "Tailing";
    public static final String MODEL_DESCRIPTION = "Model Description";
    public static final String SUGGESTED_COMPONENTS = "Suggested Components";
    public static final String AREA_PERCENT = "Area [%]";
    public static final String QUANTIFIER = "Quantifier";
    public static final String CLASSIFIER = "Classifier";
    public static final String PEAK = "PEAK";
    public static final String SCAN = "SCAN";
    private double chromatogramPeakArea = 0.0;
    public static final String[] TITLES = new String[]{"Active for Analysis", "Type", "RT [min]", "RRT [min]", "RI", "Area", "Start RT [min]", "Stop RT [min]", "Width", "Scan# at Peak Maximum", "S/N", "Leading", "Tailing", "Model Description", "Suggested Components", "Name", "Area [%]", "Quantifier", "Classifier"};
    public static final int[] BOUNDS = new int[]{30, 80, 100, 100, 60, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private Font italicFont;

    public void setChromatogramPeakArea(double chromatogramPeakArea) {
        this.chromatogramPeakArea = chromatogramPeakArea;
    }

    public Color getBackground(Object element) {
        if (element instanceof IPeak) {
            IPeak peak = (IPeak)element;
            Set peakTargets = peak.getTargets();
            for (IIdentificationTarget peakTarget : peakTargets) {
                IPeakComparisonResult peakComparisonResult;
                IComparisonResult comparisonResult = peakTarget.getComparisonResult();
                if (!(comparisonResult instanceof IPeakComparisonResult) || !(peakComparisonResult = (IPeakComparisonResult)comparisonResult).isMarkerPeak()) continue;
                return new Color((Device)DisplayUtils.getDisplay(), 255, 140, 0);
            }
        }
        return super.getBackground(element);
    }

    public Font getFont(Object element, int columnIndex) {
        AbstractPeak abstractPeak;
        if (columnIndex == 15 && element instanceof AbstractPeak && (abstractPeak = (AbstractPeak)element).isNameSet()) {
            return this.italicFont;
        }
        return null;
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        Font defaultFont = viewer.getControl().getFont();
        this.italicFont = FontDescriptor.createFrom((Font)defaultFont).setStyle(2).createFont(defaultFont.getDevice());
    }

    public void dispose(ColumnViewer viewer, ViewerColumn column) {
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        super.dispose(viewer, column);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IPeak) {
                IPeak peak = (IPeak)element;
                if (peak.isActiveForAnalysis()) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16");
            }
            if (element instanceof IScan) {
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/deselected_inactive.gif", "16x16");
            }
        } else if (columnIndex == 1) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IPeak || element instanceof IScan) {
            if (element instanceof IPeak) {
                IPeak peak = (IPeak)element;
                text = this.getPeakText(peak, columnIndex);
            } else if (element instanceof IScan) {
                IScan scan = (IScan)element;
                text = this.getScanText(scan, columnIndex);
            }
        }
        return text;
    }

    private String getPeakText(IPeak peak, int columnIndex) {
        IPeakModel peakModel = peak.getPeakModel();
        DecimalFormat decimalFormat = this.getDecimalFormat();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String text = "";
        switch (columnIndex) {
            case 0: {
                text = "";
                break;
            }
            case 1: {
                text = PEAK;
                break;
            }
            case 2: {
                text = decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0);
                break;
            }
            case 3: {
                text = decimalFormat.format((double)peakModel.getPeakMaximum().getRelativeRetentionTime() / 60000.0);
                break;
            }
            case 4: {
                boolean showRetentionIndexWithoutDecimals = preferenceStore.getBoolean("showRetentionIndexWithoutDecimals");
                if (showRetentionIndexWithoutDecimals) {
                    DecimalFormat integerFormat = this.createIntegerDecimalFormatInstance();
                    text = integerFormat.format(peakModel.getPeakMaximum().getRetentionIndex());
                    break;
                }
                text = decimalFormat.format(peakModel.getPeakMaximum().getRetentionIndex());
                break;
            }
            case 5: {
                boolean showAreaWithoutDecimals = preferenceStore.getBoolean("showAreaWithoutDecimals");
                if (showAreaWithoutDecimals) {
                    DecimalFormat integerFormat = this.createIntegerDecimalFormatInstance();
                    text = integerFormat.format(peak.getIntegratedArea());
                    break;
                }
                text = decimalFormat.format(peak.getIntegratedArea());
                break;
            }
            case 6: {
                text = decimalFormat.format((double)peakModel.getStartRetentionTime() / 60000.0);
                break;
            }
            case 7: {
                text = decimalFormat.format((double)peakModel.getStopRetentionTime() / 60000.0);
                break;
            }
            case 8: {
                text = decimalFormat.format((double)peakModel.getWidthByInflectionPoints() / 60000.0);
                break;
            }
            case 9: 
            case 10: {
                if (peak instanceof IChromatogramPeakMSD) {
                    IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)peak;
                    switch (columnIndex) {
                        case 9: {
                            text = Integer.toString(chromatogramPeak.getScanMax());
                            break;
                        }
                        case 10: {
                            text = decimalFormat.format(chromatogramPeak.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                if (peak instanceof IChromatogramPeakCSD) {
                    IChromatogramPeakCSD chromatogramPeak = (IChromatogramPeakCSD)peak;
                    switch (columnIndex) {
                        case 9: {
                            text = Integer.toString(chromatogramPeak.getScanMax());
                            break;
                        }
                        case 10: {
                            text = decimalFormat.format(chromatogramPeak.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                if (!(peak instanceof IChromatogramPeakWSD)) break;
                IChromatogramPeakWSD chromatogramPeak = (IChromatogramPeakWSD)peak;
                switch (columnIndex) {
                    case 9: {
                        text = Integer.toString(chromatogramPeak.getScanMax());
                        break;
                    }
                    case 10: {
                        text = decimalFormat.format(chromatogramPeak.getSignalToNoiseRatio());
                    }
                }
                break;
            }
            case 11: {
                text = decimalFormat.format(peakModel.getLeading());
                break;
            }
            case 12: {
                text = decimalFormat.format(peakModel.getTailing());
                break;
            }
            case 13: {
                text = peak.getModelDescription();
                break;
            }
            case 14: {
                text = Integer.toString(peak.getSuggestedNumberOfComponents());
                break;
            }
            case 15: {
                String peakName = peak.getName();
                if (peakName != null) {
                    return peakName;
                }
                ILibraryInformation libraryInformation = IIdentificationTarget.getBestLibraryInformation((Set)peak.getTargets());
                if (libraryInformation == null) break;
                return libraryInformation.getName();
            }
            case 16: {
                if (this.chromatogramPeakArea > 0.0) {
                    double peakAreaPercent = 100.0 / this.chromatogramPeakArea * peak.getIntegratedArea();
                    text = decimalFormat.format(peakAreaPercent);
                    break;
                }
                text = "-";
                break;
            }
            case 17: {
                text = peak.getInternalStandards().size() > 0 ? "ISTD" : "";
                break;
            }
            case 18: {
                ILibraryInformation libraryInformation = IIdentificationTarget.getBestLibraryInformation((Set)peak.getTargets());
                if (libraryInformation != null) {
                    LinkedHashSet set = new LinkedHashSet();
                    set.addAll(peak.getClassifier());
                    set.addAll(libraryInformation.getClassifier());
                    return Classifiable.asString(set);
                }
                return Classifiable.asString((Classifiable)peak);
            }
        }
        return text;
    }

    private String getScanText(IScan scan, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String text = "";
        switch (columnIndex) {
            case 0: {
                text = "";
                break;
            }
            case 1: {
                text = SCAN;
                break;
            }
            case 2: {
                text = decimalFormat.format((double)scan.getRetentionTime() / 60000.0);
                break;
            }
            case 3: {
                text = decimalFormat.format((double)scan.getRelativeRetentionTime() / 60000.0);
                break;
            }
            case 4: {
                boolean showRetentionIndexWithoutDecimals = preferenceStore.getBoolean("showRetentionIndexWithoutDecimals");
                if (showRetentionIndexWithoutDecimals) {
                    text = Integer.toString((int)scan.getRetentionIndex());
                    break;
                }
                text = decimalFormat.format(scan.getRetentionIndex());
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                text = "--";
                break;
            }
            case 13: {
                text = "";
                break;
            }
            case 14: {
                text = "--";
                break;
            }
            case 15: {
                ILibraryInformation libraryInformation = IIdentificationTarget.getBestLibraryInformation((Set)scan.getTargets());
                if (libraryInformation == null) break;
                text = libraryInformation.getName();
                break;
            }
            case 16: {
                text = "--";
                break;
            }
            case 17: 
            case 18: {
                text = "";
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/peak.gif", "16x16");
        return image;
    }
}

