/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.support.LibraryInformationSupport;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TargetListFilter
extends ViewerFilter {
    private String searchText;
    private String searchTextExtended;
    private boolean caseSensitive;
    private LibraryInformationSupport libraryInformationSupport = new LibraryInformationSupport();

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = searchText;
        this.searchTextExtended = ".*" + searchText + ".*";
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof IIdentificationTarget) {
            IIdentificationTarget target = (IIdentificationTarget)element;
            return this.libraryInformationSupport.matchSearchText(target.getLibraryInformation(), this.searchTextExtended, this.caseSensitive);
        }
        return false;
    }
}

