/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class TargetsEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public TargetsEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = column.equals("Verified (manually)") ? new CheckboxCellEditor((Composite)tableViewer.getTable()) : new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        if (this.column == "Verified (manually)") {
            return true;
        }
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block31: {
            if (!(element instanceof IIdentificationTarget)) break block31;
            IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
            switch (this.column) {
                case "Verified (manually)": {
                    return identificationTarget.isManuallyVerified();
                }
                case "Name": {
                    return identificationTarget.getLibraryInformation().getName();
                }
                case "CAS": {
                    return identificationTarget.getLibraryInformation().getCasNumber();
                }
                case "Comments": {
                    return identificationTarget.getLibraryInformation().getComments();
                }
                case "Formula": {
                    return identificationTarget.getLibraryInformation().getFormula();
                }
                case "SMILES": {
                    return identificationTarget.getLibraryInformation().getSmiles();
                }
                case "InChI": {
                    return identificationTarget.getLibraryInformation().getInChI();
                }
                case "Contributor": {
                    return identificationTarget.getLibraryInformation().getContributor();
                }
                case "Reference ID": {
                    return identificationTarget.getLibraryInformation().getReferenceIdentifier();
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block31: {
            if (!(element instanceof IIdentificationTarget)) break block31;
            IIdentificationTarget identificationTarget = (IIdentificationTarget)element;
            switch (this.column) {
                case "Verified (manually)": {
                    identificationTarget.setManuallyVerified(((Boolean)value).booleanValue());
                    break;
                }
                case "Name": {
                    identificationTarget.getLibraryInformation().setName((String)value);
                    break;
                }
                case "CAS": {
                    identificationTarget.getLibraryInformation().setCasNumber((String)value);
                    break;
                }
                case "Comments": {
                    identificationTarget.getLibraryInformation().setComments((String)value);
                    break;
                }
                case "Formula": {
                    identificationTarget.getLibraryInformation().setFormula((String)value);
                    break;
                }
                case "SMILES": {
                    identificationTarget.getLibraryInformation().setSmiles((String)value);
                    break;
                }
                case "InChI": {
                    identificationTarget.getLibraryInformation().setInChI((String)value);
                    break;
                }
                case "Contributor": {
                    identificationTarget.getLibraryInformation().setContributor((String)value);
                    break;
                }
                case "Reference ID": {
                    identificationTarget.getLibraryInformation().setReferenceIdentifier((String)value);
                }
            }
            this.tableViewer.refresh();
        }
    }
}

