/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.converter.quantitation.QuantDBConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class QuantDBImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(QuantDBImportRunnable.class);
    private File file;
    private IQuantitationDatabase quantitationDatabase = null;

    public QuantDBImportRunnable(File file) {
        this.file = file;
    }

    public IQuantitationDatabase getQuantitationDatabase() {
        return this.quantitationDatabase;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Quantitation Database", -1);
                IProcessingInfo processingInfo = QuantDBConverter.convert((File)this.file, (IProgressMonitor)monitor);
                this.quantitationDatabase = (IQuantitationDatabase)processingInfo.getProcessingResult(IQuantitationDatabase.class);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

