/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMarkedSignal;
import org.eclipse.chemclipse.model.core.IMarkedSignals;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferenceConstants;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.DisplayType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.Derivative;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignals;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ChromatogramChartSupport {
    public static final String EDITOR_TAB = "_EditorTab#";
    public static final String REFERENCE_MARKER = "_Reference#";
    private IColorScheme colorScheme;
    private final Map<String, Color> usedColors = new HashMap<String, Color>();
    private LineStyle lineStyle;
    private boolean showArea = false;
    private final IPreferenceStore preferenceStore;

    public ChromatogramChartSupport() {
        this(Activator.getDefault().getPreferenceStore());
    }

    public ChromatogramChartSupport(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.loadUserSettings();
    }

    public void loadUserSettings() {
        this.colorScheme = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemeDisplayOverlay"));
        this.lineStyle = LineStyle.valueOf((String)this.preferenceStore.getString("lineStyleDisplayOverlay"));
        this.showArea = this.preferenceStore.getBoolean("overlayShowArea");
        this.resetColorMaps();
    }

    public Color getSeriesColor(String seriesId, DisplayType dataType) {
        Color color = this.usedColors.get(seriesId);
        if (color == null) {
            color = this.colorScheme.getColor();
            this.colorScheme.incrementColor();
            this.usedColors.put(seriesId, color);
        }
        return color;
    }

    public ILineSeriesData getLineSeriesDataChromatogram(IChromatogramSelection chromatogramSelection, String seriesId, Color color) {
        DisplayType dataType = DisplayType.TIC;
        return this.getLineSeriesData(chromatogramSelection, seriesId, dataType, Derivative.NONE, color, null, false);
    }

    public ILineSeriesData getLineSeriesDataChromatogram(IChromatogram chromatogram, String seriesId, Color color) {
        DisplayType dataType = DisplayType.TIC;
        return this.getLineSeriesData(chromatogram, seriesId, dataType, Derivative.NONE, color, null, false);
    }

    public ILineSeriesData getLineSeriesDataBaseline(IChromatogramSelection chromatogramSelection, String seriesId, Color color) {
        DisplayType dataType = DisplayType.TIC;
        return this.getLineSeriesData(chromatogramSelection, seriesId, dataType, Derivative.NONE, color, null, true);
    }

    public ILineSeriesData getLineSeriesDataBaseline(IChromatogram chromatogram, String seriesId, Color color) {
        DisplayType dataType = DisplayType.TIC;
        return this.getLineSeriesData(chromatogram, seriesId, dataType, Derivative.NONE, color, null, true);
    }

    public ILineSeriesData getLineSeriesDataBaseline(IChromatogramSelection<?, ?> chromatogramSelection, String seriesId, DisplayType dataType, Color color, boolean timeIntervalSelection) {
        return this.getLineSeriesData(chromatogramSelection, seriesId, dataType, Derivative.NONE, color, true, timeIntervalSelection);
    }

    public ILineSeriesData getLineSeriesDataBaseline(IChromatogram<?> chromatogram, String seriesId, DisplayType dataType, Color color, IMarkedSignals<? extends IMarkedSignal> signals) {
        return this.getLineSeriesData(chromatogram, seriesId, dataType, Derivative.NONE, color, signals, true);
    }

    public ILineSeriesData getLineSeriesData(IChromatogram chromatogram, String seriesId, DisplayType dataType, Color color, IMarkedSignals<? extends IMarkedSignal> signals) {
        return this.getLineSeriesData(chromatogram, seriesId, dataType, Derivative.NONE, color, signals, false);
    }

    public ILineSeriesData getLineSeriesData(IChromatogramSelection<?, ?> chromatogramSelection, String seriesId, DisplayType dataType, Color color, boolean timeIntervalSelection) {
        return this.getLineSeriesData(chromatogramSelection, seriesId, dataType, Derivative.NONE, color, false, timeIntervalSelection);
    }

    public ILineSeriesData getLineSeriesData(IChromatogramSelection<?, ?> chromatogramSelection, String seriesId, DisplayType dataType, Derivative derivative, Color color, boolean timeIntervalSelection) {
        return this.getLineSeriesData(chromatogramSelection, seriesId, dataType, derivative, color, false, timeIntervalSelection);
    }

    public ILineSeriesData getLineSeriesData(IChromatogramSelection<?, ?> chromatogramSelection, String seriesId, DisplayType dataType, Derivative derivative, Color color, IMarkedSignals<? extends IMarkedSignal> signals, boolean baseline) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        return this.getLineSeriesData(chromatogram, startScan, stopScan, seriesId, dataType, derivative, color, signals, baseline);
    }

    public ILineSeriesData getLineSeriesData(IChromatogram chromatogram, String seriesId, DisplayType dataType, Derivative derivative, Color color, IMarkedSignals<? extends IMarkedSignal> signals, boolean baseline) {
        int startScan = 1;
        int stopScan = chromatogram.getNumberOfScans();
        return this.getLineSeriesData(chromatogram, startScan, stopScan, seriesId, dataType, derivative, color, signals, baseline);
    }

    @Deprecated
    public ILineSeriesData getLineSeriesData(IExtractedWavelengthSignals extractedWavelengthSignals, int wavelength, String seriesId, DisplayType dataType) {
        Color color = this.getSeriesColor(seriesId, dataType);
        LineStyle lineStyle = this.getLineStyle(dataType);
        int length = extractedWavelengthSignals.getExtractedWavelengthSignals().size();
        double[] xSeries = new double[length];
        double[] ySeries = new double[length];
        int index = 0;
        for (IExtractedWavelengthSignal extractedWavelengthSignal : extractedWavelengthSignals.getExtractedWavelengthSignals()) {
            xSeries[index] = extractedWavelengthSignal.getRetentionTime();
            ySeries[index] = extractedWavelengthSignal.getAbundance(wavelength);
            ++index;
        }
        SeriesData seriesData = new SeriesData(xSeries, ySeries, seriesId);
        LineSeriesData lineSeriesData = new LineSeriesData((ISeriesData)seriesData);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineColor(color);
        lineSeriesSettings.setLineStyle(lineStyle);
        lineSeriesSettings.setEnableArea(this.showArea);
        ILineSeriesSettings lineSeriesSettingsHighlight = (ILineSeriesSettings)lineSeriesSettings.getSeriesSettingsHighlight();
        lineSeriesSettingsHighlight.setLineWidth(2);
        return lineSeriesData;
    }

    private ILineSeriesData getLineSeriesData(IChromatogram chromatogram, int startScan, int stopScan, String seriesId, DisplayType dataType, Derivative derivative, Color color, IMarkedSignals<? extends IMarkedSignal> signals, boolean baseline) {
        double[] ySeries;
        double[] xSeries;
        IBaselineModel baselineModel = null;
        if (baseline) {
            if (dataType.equals((Object)DisplayType.TIC)) {
                baselineModel = chromatogram.getBaselineModel();
            } else if (dataType.equals((Object)DisplayType.SWC) && chromatogram instanceof IChromatogramWSD && signals instanceof IMarkedWavelengths) {
                IChromatogramWSD chromatogramWSD = (IChromatogramWSD)chromatogram;
                IMarkedWavelengths markedWavelengths = (IMarkedWavelengths)signals;
                if (!markedWavelengths.isEmpty()) {
                    double wavelength = ((IMarkedWavelength)markedWavelengths.iterator().next()).getWavelength();
                    baselineModel = chromatogramWSD.getBaselineModel(wavelength);
                }
            }
        }
        LineStyle lineStyle = this.getLineStyle(dataType);
        boolean condenseCycleNumberScans = this.preferenceStore.getBoolean("condenseCycleNumberScans");
        if (chromatogram.containsScanCycles() && condenseCycleNumberScans) {
            TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals totalScanSignals = totalIonSignalExtractor.getTotalScanSignals(startScan, stopScan, false, condenseCycleNumberScans);
            int length = totalScanSignals.size();
            xSeries = new double[length];
            ySeries = new double[length];
            int index = 0;
            for (ITotalScanSignal totalScanSignal : totalScanSignals.getTotalScanSignals()) {
                int retentionTime = totalScanSignal.getRetentionTime();
                xSeries[index] = retentionTime;
                ySeries[index] = baseline ? (double)baselineModel.getBackground(retentionTime) : (double)totalScanSignal.getTotalSignal();
                ++index;
            }
        } else {
            int length = stopScan - startScan + 1;
            xSeries = new double[length];
            ySeries = new double[length];
            int index = 0;
            int i = startScan;
            while (i <= stopScan) {
                IScan scan = chromatogram.getScan(i);
                int retentionTime = scan.getRetentionTime();
                xSeries[index] = retentionTime;
                ySeries[index] = baseline ? (double)baselineModel.getBackground(retentionTime) : this.getIntensity(scan, dataType, signals);
                ++index;
                ++i;
            }
        }
        int numberNaN = (int)Arrays.stream(ySeries).filter(Double::isNaN).count();
        if (numberNaN > 0) {
            int newSize = ySeries.length - numberNaN;
            double[] xSeriesWithoutNanValues = new double[newSize];
            double[] ySeriesWithoutNanValues = new double[newSize];
            int j = 0;
            int i = 0;
            while (i < ySeries.length) {
                if (!Double.isNaN(ySeries[i])) {
                    xSeriesWithoutNanValues[j] = xSeries[i];
                    ySeriesWithoutNanValues[j] = ySeries[i];
                    ++j;
                }
                ++i;
            }
            xSeries = xSeriesWithoutNanValues;
            ySeries = ySeriesWithoutNanValues;
        }
        int order = derivative.getOrder();
        int i = 1;
        while (i <= order) {
            ySeries = this.calculateDerivate(ySeries);
            ++i;
        }
        SeriesData seriesData = new SeriesData(xSeries, ySeries, seriesId);
        LineSeriesData lineSeriesData = new LineSeriesData((ISeriesData)seriesData);
        ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
        lineSeriesSettings.setLineColor(color);
        lineSeriesSettings.setLineStyle(lineStyle);
        lineSeriesSettings.setEnableArea(this.showArea);
        ILineSeriesSettings lineSeriesSettingsHighlight = (ILineSeriesSettings)lineSeriesSettings.getSeriesSettingsHighlight();
        lineSeriesSettingsHighlight.setLineWidth(2);
        return lineSeriesData;
    }

    public int getCompressionLength(String compressionType, int sizeLineSeries) {
        int compressionToLength = LineChart.LOW_COMPRESSION;
        switch (compressionType) {
            case "Auto": {
                if (sizeLineSeries >= 15) {
                    compressionToLength = LineChart.EXTREME_COMPRESSION;
                    break;
                }
                if (sizeLineSeries >= 10) {
                    compressionToLength = LineChart.HIGH_COMPRESSION;
                    break;
                }
                if (sizeLineSeries < 5) break;
                compressionToLength = LineChart.MEDIUM_COMPRESSION;
                break;
            }
            case "None": {
                compressionToLength = Integer.MAX_VALUE;
                break;
            }
            case "Low": {
                compressionToLength = LineChart.LOW_COMPRESSION;
                break;
            }
            case "Medium": {
                compressionToLength = LineChart.MEDIUM_COMPRESSION;
                break;
            }
            case "High": {
                compressionToLength = LineChart.HIGH_COMPRESSION;
                break;
            }
            case "Extreme": {
                compressionToLength = LineChart.EXTREME_COMPRESSION;
            }
        }
        return compressionToLength;
    }

    public ILineSeriesData getLineSeriesData(IChromatogramSelection<?, ?> chromatogramSelection, String seriesId, String derivativeType, Color color, boolean baseline, boolean timeIntervalSelection) {
        DisplayType dataType = null;
        dataType = chromatogramSelection instanceof IChromatogramSelectionWSD ? DisplayType.SWC : (chromatogramSelection instanceof IChromatogramSelectionMSD ? DisplayType.TIC : (chromatogramSelection instanceof IChromatogramSelectionCSD ? DisplayType.TIC : DisplayType.TIC));
        return this.getLineSeriesData(chromatogramSelection, seriesId, dataType, Derivative.NONE, color, baseline, timeIntervalSelection);
    }

    public ILineSeriesData getLineSeriesData(IChromatogramSelection<?, ?> chromatogramSelection, String seriesId, DisplayType dataType, Derivative derivative, Color color, boolean baseline, boolean timeIntervalSelection) {
        int stopScan;
        int startScan;
        IChromatogramSelectionMSD chromatogramSelectionMSD;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        IMarkedIons markedSignals = null;
        if (dataType.equals((Object)DisplayType.SIC) || dataType.equals((Object)DisplayType.XIC)) {
            chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
            markedSignals = chromatogramSelectionMSD.getSelectedIons();
        } else {
            if (dataType.equals((Object)DisplayType.SWC) || dataType.equals((Object)DisplayType.XWC)) {
                IChromatogramSelectionWSD chromatogramSelectionWSD = (IChromatogramSelectionWSD)chromatogramSelection;
                IMarkedWavelengths markedWavelengths = chromatogramSelectionWSD.getSelectedWavelengths();
                return this.getLineSeriesData(chromatogram, seriesId, dataType, derivative, color, (IMarkedSignals<? extends IMarkedSignal>)markedWavelengths, baseline);
            }
            if (dataType.equals((Object)DisplayType.TSC)) {
                chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                markedSignals = chromatogramSelectionMSD.getExcludedIons();
            } else if (dataType.equals((Object)DisplayType.BPC)) {
                chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
            } else if (!dataType.equals((Object)DisplayType.TIC)) {
                throw new IllegalArgumentException("Type " + (Object)((Object)dataType) + " is not supported");
            }
        }
        if (timeIntervalSelection) {
            startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        } else {
            startScan = 1;
            stopScan = chromatogram.getNumberOfScans();
        }
        return this.getLineSeriesData(chromatogram, startScan, stopScan, seriesId, dataType, derivative, color, (IMarkedSignals<? extends IMarkedSignal>)markedSignals, baseline);
    }

    private double getIntensity(IScan scan, DisplayType dataType, IMarkedSignals<? extends IMarkedSignal> signals) {
        double intensity = Double.NaN;
        if (dataType.equals((Object)DisplayType.TIC)) {
            intensity = scan.getTotalSignal();
        } else if (dataType.equals((Object)DisplayType.BPC)) {
            IScanMSD scanMSD;
            IIon ion;
            if (scan instanceof IScanMSD && (ion = (scanMSD = (IScanMSD)scan).getHighestAbundance()) != null) {
                intensity = ion.getAbundance();
            }
        } else if (dataType.equals((Object)DisplayType.XIC)) {
            if (scan instanceof IScanMSD && signals instanceof IMarkedIons) {
                IScanMSD scanMSD = (IScanMSD)scan;
                IMarkedIons markedIons = (IMarkedIons)signals;
                IExtractedIonSignal extractedIonSignal = scanMSD.getExtractedIonSignal();
                intensity = 0.0;
                if (signals != null) {
                    for (IMarkedIon markedIon : markedIons) {
                        intensity += (double)extractedIonSignal.getAbundance((int)markedIon.getIon());
                    }
                }
            }
        } else if (dataType.equals((Object)DisplayType.SIC)) {
            if (scan instanceof IScanMSD && signals instanceof IMarkedIons) {
                Iterator it;
                IScanMSD scanMSD = (IScanMSD)scan;
                IMarkedIons markedIons = (IMarkedIons)signals;
                IExtractedIonSignal extractedIonSignal = scanMSD.getExtractedIonSignal();
                intensity = 0.0;
                if (signals != null && (it = markedIons.iterator()).hasNext()) {
                    intensity = extractedIonSignal.getAbundance((int)((IMarkedIon)it.next()).getIon());
                }
            }
        } else if (dataType.equals((Object)DisplayType.TSC)) {
            if (scan instanceof IScanMSD && signals instanceof IMarkedIons) {
                IScanMSD scanMSD = (IScanMSD)scan;
                IMarkedIons markedIons = (IMarkedIons)signals;
                IExtractedIonSignal extractedIonSignal = scanMSD.getExtractedIonSignal();
                intensity = scanMSD.getTotalSignal();
                if (signals != null) {
                    for (IMarkedIon markedIon : markedIons) {
                        intensity -= (double)extractedIonSignal.getAbundance((int)markedIon.getIon());
                    }
                }
            }
        } else if (dataType.equals((Object)DisplayType.SWC) | dataType.equals((Object)DisplayType.XWC) && scan instanceof IScanWSD && signals instanceof IMarkedWavelengths) {
            Optional scanSignal;
            IScanWSD scanWSD = (IScanWSD)scan;
            IMarkedWavelengths markedWavelengths = (IMarkedWavelengths)signals;
            Iterator it = markedWavelengths.iterator();
            if (it.hasNext() && (scanSignal = scanWSD.getScanSignal(((IMarkedWavelength)it.next()).getWavelength())).isPresent()) {
                intensity = ((IScanSignalWSD)scanSignal.get()).getAbundance();
            }
        }
        return intensity;
    }

    private LineStyle getLineStyle(DisplayType dataType) {
        return this.lineStyle;
    }

    private double[] calculateDerivate(double[] values) {
        int size = values.length;
        double[] derivative = new double[size];
        int i = 1;
        while (i < size) {
            derivative[i] = values[i] - values[i - 1];
            ++i;
        }
        return derivative;
    }

    private void resetColorMaps() {
        this.colorScheme.reset();
        this.usedColors.clear();
    }

    public static IPreferenceStore initializeDefaults(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("colorSchemeDisplayOverlay", "Print");
        preferenceStore.setDefault("lineStyleDisplayOverlay", PreferenceConstants.DEF_LINE_STYLE_DISPLAY_OVERLAY);
        preferenceStore.setDefault("overlayShowArea", false);
        preferenceStore.setDefault("condenseCycleNumberScans", true);
        return preferenceStore;
    }
}

