/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.columns.SimpleColumnDefinition;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.ui.provider.DataExplorerLabelProvider;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ConfigurableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.DataListUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputEntriesWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputWizardSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DataListUI
implements ConfigurableUI<DataListUIConfig> {
    private ExtendedTableViewer tableViewer;
    private List<File> files = new ArrayList<File>();
    private Consumer<Boolean> dirtyListener;
    private Composite control;
    private InputWizardSettings inputWizardSettings;
    private Composite toolbarMain;

    public DataListUI(Composite parent, Consumer<Boolean> dirtyListener, IPreferenceStore preferenceStore, String userPathKey, DataType ... dataTypes) {
        this.dirtyListener = dirtyListener;
        this.inputWizardSettings = InputWizardSettings.create(preferenceStore, userPathKey, dataTypes);
        this.inputWizardSettings.setTitle("Select files");
        this.inputWizardSettings.setDescription("Select items(s) to process.");
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarTop(this.control);
        this.createTableViewer(this.control);
        this.createToolbarBottom(this.control);
    }

    public ExtendedTableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new ExtendedTableViewer(composite, 68354);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.files);
        final DataExplorerLabelProvider dataExplorerLabelProvider = new DataExplorerLabelProvider((Function)this.inputWizardSettings.getSupplierCache());
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dataExplorerLabelProvider.dispose();
            }
        });
        this.tableViewer.addColumn((ColumnDefinition)new SimpleColumnDefinition("Name", 250, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    return DataListUI.this.getName((File)element);
                }
                return "-";
            }

            public Image getImage(Object element) {
                Image image = dataExplorerLabelProvider.getImage(element);
                return image;
            }
        }, null, this::getName));
        this.tableViewer.addColumn((ColumnDefinition)new SimpleColumnDefinition("Path", 300, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    return DataListUI.this.getPath((File)element);
                }
                return "-";
            }
        }, null, this::getPath));
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
    }

    private void createToolbarTop(Composite parent) {
        this.toolbarMain = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        this.toolbarMain.setLayoutData((Object)gridData);
        this.toolbarMain.setLayout((Layout)new GridLayout(1, false));
        Button button = new Button(this.toolbarMain, 8);
        button.setToolTipText("Open the Settings");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferencePage preferencePage = DataListUI.this.inputWizardSettings.getPreferencePage();
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(DisplayUtils.getShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                preferenceDialog.open();
            }
        });
    }

    private void createToolbarBottom(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        toolBar.setLayoutData((Object)gridData);
        this.createMoveUpButton(toolBar);
        this.createMoveDownButton(toolBar);
        this.createRemoveButton(toolBar);
        this.createAddButton(toolBar);
    }

    private ToolItem createMoveUpButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_up_2.gif", "16x16"));
        item.setToolTipText("Move the item(s) up.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = DataListUI.this.tableViewer.getTable();
                ISelection selection = DataListUI.this.tableViewer.getSelection();
                int[] nArray = table.getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    Collections.swap(DataListUI.this.files, index, index - 1);
                    ++n2;
                }
                DataListUI.this.updateList(true);
                DataListUI.this.tableViewer.setSelection(selection);
            }
        });
        return item;
    }

    private ToolItem createMoveDownButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_down_2.gif", "16x16"));
        item.setToolTipText("Move the item(s) down.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = DataListUI.this.tableViewer.getTable();
                int[] indices = table.getSelectionIndices();
                ISelection selection = DataListUI.this.tableViewer.getSelection();
                int i = indices.length - 1;
                while (i >= 0) {
                    int index = indices[i];
                    Collections.swap(DataListUI.this.files, index, index + 1);
                    --i;
                }
                DataListUI.this.updateList(true);
                DataListUI.this.tableViewer.setSelection(selection);
            }
        });
        return item;
    }

    private ToolItem createRemoveButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        item.setToolTipText("Remove the selected item(s).");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = DataListUI.this.tableViewer.getStructuredSelection().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    DataListUI.this.files.remove(object);
                    DataListUI.this.removed((File)object);
                    ++n2;
                }
                DataListUI.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                DataListUI.this.updateList(true);
            }
        });
        return item;
    }

    protected void removed(File file) {
    }

    protected void addFiles(Collection<File> newFiles) {
        this.files.addAll(newFiles);
    }

    private ToolItem createAddButton(ToolBar toolBar) {
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        item.setToolTipText("Add item(s) to the list.");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set<File> newFiles = InputEntriesWizard.openWizard(DataListUI.this.getControl().getShell(), DataListUI.this.inputWizardSettings).keySet();
                if (!newFiles.isEmpty()) {
                    DataListUI.this.addFiles(newFiles);
                    DataListUI.this.updateList(true);
                }
            }
        });
        return item;
    }

    public void setFiles(Collection<File> files) {
        this.files.clear();
        if (files != null) {
            this.files.addAll(files);
        }
        this.updateList(false);
    }

    private void updateList(boolean dirtyStatus) {
        this.dirtyListener.accept(dirtyStatus);
        this.tableViewer.refresh();
    }

    public String getPath(File file) {
        return file.getAbsolutePath();
    }

    public String getName(File file) {
        if (file.exists()) {
            return file.getName();
        }
        return "File doesn't exist.";
    }

    public Control getControl() {
        return this.control;
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    @Override
    public DataListUIConfig getConfig() {
        return new DataListUIConfig(){

            @Override
            public void setToolbarVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)DataListUI.this.toolbarMain, (boolean)visible);
            }

            @Override
            public boolean isToolbarVisible() {
                return DataListUI.this.toolbarMain.isVisible();
            }

            @Override
            public IPreferencePage[] getPreferencePages() {
                return new IPreferencePage[]{DataListUI.this.inputWizardSettings.getPreferencePage()};
            }

            @Override
            public void applySettings() {
            }
        };
    }
}

