/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.model.support.RetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.IColumnMoveListener;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.preferences.PreferencePageSWT;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.dialogs.InternalStandardDialog;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.TableConfigSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.ListSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageLists;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ConfigurableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakScanListUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakScanListUIConfig;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ExtendedPeakScanListUI
implements ConfigurableUI<PeakScanListUIConfig> {
    private static final Logger logger = Logger.getLogger(ExtendedPeakScanListUI.class);
    private static final String MENU_CATEGORY = "Peaks/Scans";
    private final ListSupport listSupport = new ListSupport();
    private final TargetExtendedComparator comparator = new TargetExtendedComparator(SortOrder.DESC);
    private final IPreferenceStore preferenceStore;
    private final IEventBroker eventBroker;
    private Composite toolbarInfoTop;
    private Composite toolbarInfoBottom;
    private Composite toolbarSearch;
    private Button buttonSave;
    private Label labelChromatogramName;
    private Label labelChromatogramInfo;
    private SearchSupportUI searchSupportUI;
    private PeakScanListUI peakScanListUI;
    private IChromatogramSelection chromatogramSelection;
    private Composite toolbarMain;
    private Composite toolbarLabel;
    private boolean showScans;
    private boolean showPeaks;
    private boolean showScansInRange;
    private boolean showPeaksInRange;
    private boolean moveRetentionTimeOnPeakSelection;
    private PeakScanListUIConfig.InteractionMode interactionMode = PeakScanListUIConfig.InteractionMode.SOURCE;
    private int currentModCount;
    private RetentionTimeRange lastRange;

    public ExtendedPeakScanListUI(Composite parent, IEventBroker eventBroker, IPreferenceStore preferenceStore) {
        this.eventBroker = eventBroker;
        this.preferenceStore = preferenceStore;
        this.initialize(parent);
    }

    private void updateFromPreferences() {
        if (this.preferenceStore != null) {
            this.showPeaks = this.preferenceStore.getBoolean("showPeaksInList");
            this.showPeaksInRange = this.preferenceStore.getBoolean("showPeaksInSelectedRange");
            this.showScans = this.preferenceStore.getBoolean("showScansInList");
            this.showScansInRange = this.preferenceStore.getBoolean("showScansInSelectedRange");
            this.moveRetentionTimeOnPeakSelection = this.preferenceStore.getBoolean("moveRetentionTimeOnPeakSelection");
        }
    }

    @Focus
    public void setFocus() {
        this.updateChromatogramSelection();
    }

    public void updateChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        if (this.hasChanged(chromatogramSelection)) {
            this.chromatogramSelection = chromatogramSelection;
            this.updateChromatogramSelection();
        }
    }

    private boolean hasChanged(IChromatogramSelection chromatogramSelection) {
        boolean referenceChanged;
        boolean bl = referenceChanged = this.chromatogramSelection != chromatogramSelection;
        if (!referenceChanged && chromatogramSelection != null) {
            if (chromatogramSelection.getChromatogram().getModCount() != this.currentModCount) {
                return true;
            }
            if (this.lastRange != null && !this.lastRange.contentEquals((IRetentionTimeRange)chromatogramSelection)) {
                return true;
            }
        }
        return referenceChanged;
    }

    public void updateChromatogramSelection() {
        this.updateFromPreferences();
        this.updateLabel();
        this.buttonSave.setEnabled(false);
        if (this.chromatogramSelection == null) {
            this.peakScanListUI.clear();
            this.currentModCount = -1;
        } else {
            this.currentModCount = this.chromatogramSelection.getChromatogram().getModCount();
            this.lastRange = new RetentionTimeRange((IRetentionTimeRange)this.chromatogramSelection);
            this.peakScanListUI.setInput(this.chromatogramSelection, this.showPeaks, this.showPeaksInRange, this.showScans, this.showScansInRange);
            IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
            if (chromatogram instanceof IChromatogramMSD) {
                this.buttonSave.setEnabled(true);
            }
            if (this.interactionMode == PeakScanListUIConfig.InteractionMode.SINK || this.interactionMode == PeakScanListUIConfig.InteractionMode.BIDIRECTIONAL) {
                this.updateSelection();
            }
        }
    }

    public void updateSelection() {
        PeakScanListUIConfig.InteractionMode oldMode = this.interactionMode;
        try {
            this.interactionMode = PeakScanListUIConfig.InteractionMode.NONE;
            ArrayList<Object> selection = new ArrayList<Object>(2);
            if (this.chromatogramSelection != null) {
                IScan selectedScan;
                IPeak selectedPeak;
                if (this.showPeaks && (selectedPeak = this.chromatogramSelection.getSelectedPeak()) != null) {
                    selection.add(selectedPeak);
                }
                if (this.showScans && (selectedScan = this.chromatogramSelection.getSelectedIdentifiedScan()) != null) {
                    selection.add(selectedScan);
                }
            }
            this.peakScanListUI.setSelection((ISelection)new StructuredSelection(selection), true);
        }
        finally {
            this.interactionMode = oldMode;
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfoTop = this.createToolbarInfoTop(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.peakScanListUI = this.createPeakTable(parent);
        this.toolbarInfoBottom = this.createToolbarInfoBottom(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoTop, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoBottom, (boolean)true);
        this.peakScanListUI.setEditEnabled(false);
    }

    private void createToolbarMain(Composite parent) {
        this.toolbarMain = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        this.toolbarMain.setLayoutData((Object)gridData);
        this.toolbarMain.setLayout((Layout)new GridLayout(6, false));
        this.createButtonToggleToolbarInfo(this.toolbarMain);
        this.createButtonToggleToolbarSearch(this.toolbarMain);
        this.createButtonToggleEditModus(this.toolbarMain);
        this.createResetButton(this.toolbarMain);
        this.buttonSave = this.createSaveButton(this.toolbarMain);
        this.createSettingsButton(this.toolbarMain);
    }

    private Composite createToolbarInfoTop(Composite parent) {
        this.toolbarLabel = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        this.toolbarLabel.setLayoutData((Object)gridData);
        this.toolbarLabel.setLayout((Layout)new GridLayout(1, false));
        this.labelChromatogramName = new Label(this.toolbarLabel, 0);
        this.labelChromatogramName.setText("");
        this.labelChromatogramName.setLayoutData((Object)new GridData(768));
        return this.toolbarLabel;
    }

    private Composite createToolbarSearch(Composite parent) {
        this.searchSupportUI = new SearchSupportUI(parent, 0);
        this.searchSupportUI.setLayoutData((Object)new GridData(768));
        this.searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedPeakScanListUI.this.peakScanListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return this.searchSupportUI;
    }

    private PeakScanListUI createPeakTable(Composite parent) {
        PeakScanListUI listUI = new PeakScanListUI(parent, 68354);
        final Table table = listUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakScanListUI.this.propagateSelection(e.display);
            }
        });
        final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        final String preferenceName = "columnOrderPeakScanList";
        this.listSupport.setColumnOrder(table, preferenceStore.getString(preferenceName));
        listUI.addColumnMoveListener(new IColumnMoveListener(){

            public void handle() {
                String columnOrder = ExtendedPeakScanListUI.this.listSupport.getColumnOrder(table);
                preferenceStore.setValue(preferenceName, columnOrder);
            }
        });
        Display display = listUI.getTable().getDisplay();
        ITableSettings tableSettings = listUI.getTableSettings();
        this.addDeleteMenuEntry(display, tableSettings);
        this.addVerifyTargetsMenuEntry(tableSettings);
        this.addUnverifyTargetsMenuEntry(tableSettings);
        this.modifyInternalStandardsMenuEntry(display, tableSettings);
        this.addKeyEventProcessors(display, tableSettings);
        listUI.applySettings(tableSettings);
        return listUI;
    }

    private void addDeleteMenuEntry(final Display display, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Peak(s)/Scan Identification(s)";
            }

            public String getCategory() {
                return ExtendedPeakScanListUI.MENU_CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedPeakScanListUI.this.deletePeaksOrIdentifications(display);
            }
        });
    }

    private void addVerifyTargetsMenuEntry(ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Select Peak(s) for Analysis";
            }

            public String getCategory() {
                return ExtendedPeakScanListUI.MENU_CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedPeakScanListUI.this.setPeaksActiveForAnalysis(true);
            }
        });
    }

    private void addUnverifyTargetsMenuEntry(ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Deselect Peak(s) for Analysis";
            }

            public String getCategory() {
                return ExtendedPeakScanListUI.MENU_CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedPeakScanListUI.this.setPeaksActiveForAnalysis(false);
            }
        });
    }

    private void modifyInternalStandardsMenuEntry(final Display display, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Modify ISTDs (Internal Standards)";
            }

            public String getCategory() {
                return ExtendedPeakScanListUI.MENU_CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedPeakScanListUI.this.modifyInternalStandards(display);
            }
        });
    }

    private void addKeyEventProcessors(final Display display, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedPeakScanListUI.this.deletePeaksOrIdentifications(display);
                } else if (e.keyCode == 105 && (e.stateMask & 0x40000) == 262144) {
                    if ((e.stateMask & 0x10000) == 65536) {
                        ExtendedPeakScanListUI.this.setPeaksActiveForAnalysis(false);
                    } else {
                        ExtendedPeakScanListUI.this.setPeaksActiveForAnalysis(true);
                    }
                } else if (e.keyCode == 115 && (e.stateMask & 0x40000) == 262144) {
                    ExtendedPeakScanListUI.this.modifyInternalStandards(display);
                } else {
                    ExtendedPeakScanListUI.this.propagateSelection(display);
                }
            }
        });
    }

    private void deletePeaksOrIdentifications(Display display) {
        MessageBox messageBox = new MessageBox(display.getActiveShell(), 196);
        messageBox.setText("Delete Peak(s)/Scan Identification(s)");
        messageBox.setMessage("Would you like to delete the selected peak(s)/scan identification(s)?");
        if (messageBox.open() == 64) {
            Iterator iterator = this.peakScanListUI.getStructuredSelection().iterator();
            ArrayList<IScan> scansToClear = new ArrayList<IScan>();
            ArrayList<IPeak> peaksToDelete = new ArrayList<IPeak>();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof IPeak) {
                    peaksToDelete.add((IPeak)object);
                    continue;
                }
                if (!(object instanceof IScan)) continue;
                scansToClear.add((IScan)object);
            }
            this.deleteScanIdentifications(scansToClear);
            this.deletePeaks(peaksToDelete);
            if ((scansToClear.size() > 0 || peaksToDelete.size() > 0) && this.chromatogramSelection != null) {
                this.chromatogramSelection.update(true);
            }
            this.sendEvent(display, "chromatogram/xxd/load/chromatogramselection", this.chromatogramSelection);
            this.updateChromatogramSelection();
        }
    }

    private void setPeaksActiveForAnalysis(boolean activeForAnalysis) {
        for (Object object : this.peakScanListUI.getStructuredSelection()) {
            if (!(object instanceof IPeak)) continue;
            IPeak peak = (IPeak)object;
            peak.setActiveForAnalysis(activeForAnalysis);
        }
        this.updateChromatogramSelection();
    }

    private void deleteScanIdentifications(List<IScan> scans) {
        if (scans.size() > 0) {
            if (this.chromatogramSelection != null) {
                this.chromatogramSelection.removeSelectedIdentifiedScan();
            }
            for (IScan scan : scans) {
                scan.getTargets().clear();
            }
        }
    }

    private void deletePeaks(List<IPeak> peaks) {
        if (peaks.size() > 0 && this.chromatogramSelection != null) {
            IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
            chromatogram.removePeaks(peaks);
        }
    }

    private void modifyInternalStandards(Display display) {
        MessageBox messageBox = new MessageBox(display.getActiveShell(), 196);
        messageBox.setText("Internal Standard (ISTD)");
        messageBox.setMessage("Would you like to modify the ISTD(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.peakScanListUI.getStructuredSelection()) {
                InternalStandardDialog dialog;
                IPeak peak;
                if (!(object instanceof IPeak) || !((peak = (IPeak)object).getIntegratedArea() > 0.0) || (dialog = new InternalStandardDialog(display.getActiveShell(), peak)).open() != 0) continue;
                logger.info((Object)"Successfully modified ISTDs.");
            }
            this.sendEvent(display, "chromatogram/xxd/load/chromatogramselection", this.chromatogramSelection);
        }
    }

    private void propagateSelection(Display display) {
        if (this.interactionMode != PeakScanListUIConfig.InteractionMode.SOURCE && this.interactionMode != PeakScanListUIConfig.InteractionMode.BIDIRECTIONAL) {
            return;
        }
        IStructuredSelection selection = this.peakScanListUI.getStructuredSelection();
        if (!selection.isEmpty()) {
            List list = selection.toList();
            if (list.size() > 1) {
                return;
            }
            for (Object object : list) {
                HashMap<String, Object> map;
                IIdentificationTarget target;
                if (object instanceof IPeak) {
                    IPeak peak = (IPeak)object;
                    target = IIdentificationTarget.getBestIdentificationTarget((Set)peak.getTargets(), (Comparator)this.comparator);
                    if (this.moveRetentionTimeOnPeakSelection) {
                        ChromatogramDataSupport.adjustChromatogramSelection(peak, this.chromatogramSelection);
                    }
                    this.chromatogramSelection.setSelectedPeak(peak);
                    this.sendEvent(display, "peak/xxd/update/selection", peak);
                    this.sendEvent(display, "identification/target/update", target);
                    if (!(peak instanceof IPeakMSD)) continue;
                    IPeakMSD peakMSD = (IPeakMSD)peak;
                    map = new HashMap<String, Object>();
                    map.put("MassSpectrumUnknown", peakMSD.getExtractedMassSpectrum());
                    map.put("IdentificationTarget", target);
                    this.sendEvent(display, "identification/target/update/massspectrum/unknown", map);
                    continue;
                }
                if (!(object instanceof IScan)) continue;
                IScan scan = (IScan)object;
                target = IIdentificationTarget.getBestIdentificationTarget((Set)scan.getTargets(), (Comparator)this.comparator);
                this.chromatogramSelection.setSelectedIdentifiedScan(scan);
                this.sendEvent(display, "scan/xxd/update/selection", scan);
                this.sendEvent(display, "identification/target/update", target);
                if (!(scan instanceof IScanMSD)) continue;
                IScanMSD scanMSD = (IScanMSD)scan;
                map = new HashMap();
                map.put("MassSpectrumUnknown", scanMSD);
                map.put("IdentificationTarget", target);
                this.sendEvent(display, "identification/target/update/massspectrum/unknown", map);
            }
        }
    }

    private void sendEvent(Display display, final String topic, final Object data) {
        if (display != null && this.eventBroker != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExtendedPeakScanListUI.this.eventBroker.send(topic, data);
                }
            });
        }
    }

    private Composite createToolbarInfoBottom(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelChromatogramInfo = new Label(composite, 0);
        this.labelChromatogramInfo.setText("");
        this.labelChromatogramInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakScanListUI.this.toolbarInfoTop);
                PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakScanListUI.this.toolbarInfoBottom);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakScanListUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedPeakScanListUI.this.peakScanListUI.isEditEnabled();
                ExtendedPeakScanListUI.this.peakScanListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedPeakScanListUI.this.updateLabel();
            }
        });
        return button;
    }

    public void setEditEnabled(boolean editEnabled) {
        this.peakScanListUI.setEditEnabled(editEnabled);
        this.updateLabel();
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the peak/scan list.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakScanListUI.this.reset();
            }
        });
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save the peak/scan list.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedPeakScanListUI.this.chromatogramSelection != null && ExtendedPeakScanListUI.this.chromatogramSelection.getChromatogram() != null) {
                        IChromatogram chromatogram = ExtendedPeakScanListUI.this.chromatogramSelection.getChromatogram();
                        Table table = ExtendedPeakScanListUI.this.peakScanListUI.getTable();
                        int[] indices = table.getSelectionIndices();
                        List peaks = indices.length == 0 ? ExtendedPeakScanListUI.this.getPeakList(table) : ExtendedPeakScanListUI.this.getPeakList(table, indices);
                        if (peaks.size() > 0) {
                            DatabaseFileSupport.savePeaks((Shell)e.display.getActiveShell(), (List)peaks, (String)chromatogram.getName());
                        }
                        List scans = indices.length == 0 ? ExtendedPeakScanListUI.this.getScanList(table) : ExtendedPeakScanListUI.this.getScanList(table, indices);
                        MassSpectra massSpectra = new MassSpectra();
                        for (IScan scan : scans) {
                            if (!(scan instanceof IScanMSD)) continue;
                            massSpectra.addMassSpectrum((IScanMSD)scan);
                        }
                        if (massSpectra.size() > 0) {
                            DatabaseFileSupport.saveMassSpectra((Shell)e.display.getActiveShell(), (IMassSpectra)massSpectra, (String)chromatogram.getName());
                        }
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        if (this.preferenceStore != null) {
            Button button = new Button(parent, 8);
            button.setToolTipText("Open the Settings");
            button.setText("");
            button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencePageSWT preferencePageSWT = new PreferencePageSWT();
                    preferencePageSWT.setTitle("Settings (SWT)");
                    PreferencePageLists preferencePageLists = new PreferencePageLists();
                    preferencePageLists.setTitle("Lists");
                    PreferenceManager preferenceManager = new PreferenceManager();
                    preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageSWT));
                    preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageLists));
                    PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                    preferenceDialog.create();
                    preferenceDialog.setMessage("Settings");
                    if (preferenceDialog.open() == 0) {
                        try {
                            ExtendedPeakScanListUI.this.applySettings();
                        }
                        catch (Exception e1) {
                            MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                        }
                    }
                }
            });
        }
    }

    private void updateLabel() {
        if (this.labelChromatogramName.isDisposed() || this.labelChromatogramInfo.isDisposed()) {
            return;
        }
        if (this.chromatogramSelection == null || this.chromatogramSelection.getChromatogram() == null) {
            this.labelChromatogramName.setText(ChromatogramDataSupport.getChromatogramLabel(null));
            this.labelChromatogramInfo.setText("");
        } else {
            String editInformation = this.peakScanListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
            IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
            String chromatogramLabel = ChromatogramDataSupport.getChromatogramLabel(chromatogram);
            int identifiedPeaks = chromatogram.getNumberOfPeaks();
            int identifiedScans = ChromatogramDataSupport.getIdentifiedScans(chromatogram).size();
            this.labelChromatogramName.setText(String.valueOf(chromatogramLabel) + " - " + editInformation);
            this.labelChromatogramInfo.setText("Number of Peaks: " + identifiedPeaks + " | Scans: " + identifiedScans);
        }
    }

    private void applySettings() {
        this.searchSupportUI.reset();
        this.updateChromatogramSelection();
    }

    private void reset() {
        this.updateChromatogramSelection();
    }

    private List<IPeak> getPeakList(Table table) {
        ArrayList<IPeak> peakList = new ArrayList<IPeak>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object instanceof IPeak) {
                peakList.add((IPeak)object);
            }
            ++n2;
        }
        return peakList;
    }

    private List<IPeak> getPeakList(Table table, int[] indices) {
        ArrayList<IPeak> peakList = new ArrayList<IPeak>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IPeak) {
                peakList.add((IPeak)object);
            }
            ++n2;
        }
        return peakList;
    }

    private List<IScan> getScanList(Table table) {
        ArrayList<IScan> scanList = new ArrayList<IScan>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object instanceof IScan) {
                scanList.add((IScan)object);
            }
            ++n2;
        }
        return scanList;
    }

    private List<IScan> getScanList(Table table, int[] indices) {
        ArrayList<IScan> scanList = new ArrayList<IScan>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IScan) {
                scanList.add((IScan)object);
            }
            ++n2;
        }
        return scanList;
    }

    @Override
    public PeakScanListUIConfig getConfig() {
        return new PeakScanListUIConfig(){
            TableConfigSupport tableConfig = new TableConfigSupport(() -> ((PeakScanListUI)ExtendedPeakScanListUI.access$1(extendedPeakScanListUI)).getTableViewerColumns());

            @Override
            public void setToolbarVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedPeakScanListUI.this.toolbarMain, (boolean)visible);
            }

            @Override
            public boolean isToolbarVisible() {
                return ExtendedPeakScanListUI.this.toolbarMain.isVisible();
            }

            @Override
            public void setToolbarInfoVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedPeakScanListUI.this.toolbarLabel, (boolean)visible);
            }

            @Override
            public boolean hasToolbarInfo() {
                return true;
            }

            @Override
            public void setVisibleColumns(Set<String> visibleColumns) {
                this.tableConfig.setVisibleColumns(visibleColumns);
            }

            @Override
            public void setShowScans(boolean show, boolean inRange) {
                ExtendedPeakScanListUI.this.showScans = show;
                ExtendedPeakScanListUI.this.showScansInRange = inRange;
            }

            @Override
            public void setShowPeaks(boolean show, boolean inRange) {
                ExtendedPeakScanListUI.this.showPeaks = show;
                ExtendedPeakScanListUI.this.showPeaksInRange = inRange;
            }

            @Override
            public void setMoveRetentionTimeOnPeakSelection(boolean enabled) {
                ExtendedPeakScanListUI.this.moveRetentionTimeOnPeakSelection = enabled;
            }

            @Override
            public void setInteractionMode(PeakScanListUIConfig.InteractionMode interactionMode) {
                ExtendedPeakScanListUI.this.interactionMode = interactionMode;
            }

            @Override
            public Set<String> getColumns() {
                return this.tableConfig.getColumns();
            }

            @Override
            public int getColumWidth(String column) {
                return this.tableConfig.getColumWidth(column);
            }

            @Override
            public void setColumWidth(String column, int width) {
                this.tableConfig.setColumWidth(column, width);
            }
        };
    }
}

