/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.calculator.SubtractCalculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.IUpdateListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChartConfigSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.SignalType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.DataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.parts.ScanChartPart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageSubtract;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.AxisConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ConfigurableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanChartUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanChartUIConfig;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanFilterUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanIdentifierUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.SubtractScanWizard;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedScanChartUI
implements ConfigurableUI<ScanChartUIConfig> {
    private static final Logger logger = Logger.getLogger(ScanChartPart.class);
    private final IEventBroker eventBroker;
    private Composite toolbarMain;
    private Composite toolbarInfo;
    private Composite toolbarEdit;
    private Composite toolbarTypes;
    private CLabel labelEdit;
    private CLabel labelSubtract;
    private CLabel labelOptimized;
    private Label labelScan;
    private Button buttonEdit;
    private Button buttonCopyTraces;
    private Button buttonSave;
    private Button buttonDeleteOptimized;
    private ScanChartUI scanChartUI;
    private Combo comboDataType;
    private Combo comboSignalType;
    private Button buttonSubtractOption;
    private ScanFilterUI scanFilterUI;
    private ScanIdentifierUI scanIdentifierUI;
    private IScan scan;
    private final ScanDataSupport scanDataSupport = new ScanDataSupport();
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private boolean editModus = false;
    private boolean subtractModus = false;
    private Color backgroundDefault;

    public ExtendedScanChartUI(Composite parent, IEventBroker eventBroker) {
        this.eventBroker = eventBroker;
        this.initialize(parent);
    }

    @Override
    public ScanChartUIConfig getConfig() {
        return new ScanChartUIConfig(){
            ChartConfigSupport axisSupport;
            {
                this.axisSupport = new ChartConfigSupport(ExtendedScanChartUI.this.scanChartUI, EnumSet.of(AxisConfig.ChartAxis.PRIMARY_X, AxisConfig.ChartAxis.PRIMARY_Y, AxisConfig.ChartAxis.SECONDARY_Y));
            }

            @Override
            public void setToolbarVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedScanChartUI.this.toolbarMain, (boolean)visible);
            }

            @Override
            public boolean isToolbarVisible() {
                return ExtendedScanChartUI.this.toolbarMain.isVisible();
            }

            @Override
            public boolean hasToolbarInfo() {
                return true;
            }

            @Override
            public void setToolbarInfoVisible(boolean visible) {
                PartSupport.setCompositeVisibility((Composite)ExtendedScanChartUI.this.toolbarInfo, (boolean)visible);
            }

            @Override
            public void setAxisLabelVisible(AxisConfig.ChartAxis axis, boolean visible) {
                this.axisSupport.setAxisLabelVisible(axis, visible);
            }

            @Override
            public void setAxisVisible(AxisConfig.ChartAxis axis, boolean visible) {
                this.axisSupport.setAxisVisible(axis, visible);
            }

            @Override
            public boolean hasAxis(AxisConfig.ChartAxis axis) {
                return this.axisSupport.hasAxis(axis);
            }
        };
    }

    public void update(IScan scan) {
        this.update(scan, DisplayUtils.getDisplay());
    }

    private void update(IScan scan, Display display) {
        if (this.editModus) {
            if (this.subtractModus && this.scan instanceof IScanMSD) {
                IScanMSD scanSource = (IScanMSD)this.scan;
                if (scan instanceof IScanMSD) {
                    IScanMSD scanSubtract = (IScanMSD)scan;
                    this.subtractScanMSD(scanSource, scanSubtract);
                    if (!this.preferenceStore.getBoolean("enableMultiSubtract")) {
                        this.setSubtractModus(display, false, false);
                        this.updateInfoLabels();
                    }
                    this.fireUpdateChromatogramSelection(display, (IScan)scanSource);
                    this.updateScan((IScan)scanSource);
                }
            }
        } else {
            this.updateScan(scan);
        }
    }

    private void updateScan(IScan scan) {
        this.scan = scan;
        this.scanFilterUI.setInput(scan);
        this.scanIdentifierUI.setInput(scan);
        this.labelScan.setText(this.scanDataSupport.getScanLabel(scan));
        this.setDetectorSignalType(scan);
        this.updateScanChart(scan);
        this.updateInfoLabels();
        this.updateButtons();
    }

    private void updateScanChart(IScan scan) {
        IScanMSD optimizedMassSpectrum = this.getOptimizedScanMSD();
        if (optimizedMassSpectrum != null) {
            this.scanChartUI.setInput((IScan)optimizedMassSpectrum);
        } else {
            this.scanChartUI.setInput(scan);
        }
    }

    private void initialize(Composite parent) {
        Composite container = ControlBuilder.createContainer((Composite)parent);
        this.backgroundDefault = container.getBackground();
        this.toolbarMain = this.createToolbarMain(container);
        this.toolbarInfo = this.createToolbarInfo(container);
        this.toolbarTypes = this.createToolbarTypes(container);
        this.toolbarEdit = this.createToolbarEdit(container);
        this.scanChartUI = this.createScanChart(container);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarTypes, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarEdit, (boolean)false);
        this.updateButtons();
    }

    private Composite createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(11, false));
        this.labelEdit = this.createInfoLabelEdit(composite);
        this.labelSubtract = this.createInfoLabelSubtract(composite);
        this.labelOptimized = this.createInfoLabelOptimized(composite);
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarTypes(composite);
        this.buttonEdit = this.createButtonToggleToolbarEdit(composite);
        this.buttonCopyTraces = this.createButtonCopyTracesClipboard(composite);
        this.createResetButton(composite);
        this.buttonSave = this.createSaveButton(composite);
        this.buttonDeleteOptimized = this.createDeleteOptimizedButton(composite);
        this.createSettingsButton(composite);
        return composite;
    }

    private CLabel createInfoLabelEdit(Composite parent) {
        final CLabel label = this.createInfoLabel(parent);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!"".equals(label.getText())) {
                    ExtendedScanChartUI.this.setEditToolbarStatus(false);
                    ExtendedScanChartUI.this.updateInfoLabels();
                }
            }
        });
        return label;
    }

    private CLabel createInfoLabelSubtract(Composite parent) {
        final CLabel label = this.createInfoLabel(parent);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!"".equals(label.getText())) {
                    ExtendedScanChartUI.this.setSubtractModus(e.display, false, false);
                    ExtendedScanChartUI.this.updateInfoLabels();
                }
            }
        });
        return label;
    }

    private CLabel createInfoLabelOptimized(Composite parent) {
        final CLabel label = this.createInfoLabel(parent);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!"".equals(label.getText())) {
                    ExtendedScanChartUI.this.deleteOptimizedScan(e.widget.getDisplay());
                }
            }
        });
        return label;
    }

    private CLabel createInfoLabel(Composite parent) {
        CLabel label = new CLabel(parent, 0x1000000);
        label.setForeground(Colors.RED);
        label.setLayoutData((Object)new GridData(768));
        return label;
    }

    private Composite createToolbarTypes(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.comboDataType = this.createDataType(composite);
        this.comboDataType.setLayoutData((Object)new GridData(768));
        this.comboSignalType = this.createSignalType(composite);
        this.comboSignalType.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarEdit(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.buttonSubtractOption = this.createButtonSubtractOption(composite);
        this.scanFilterUI = this.createScanFilterUI(composite);
        this.scanIdentifierUI = this.createScanIdentifierUI(composite);
        return composite;
    }

    private Button createButtonSubtractOption(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Enable/Disable the interactive subtract option.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractScanDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanChartUI.this.setSubtractModus(e.display, !ExtendedScanChartUI.this.subtractModus, true);
                ExtendedScanChartUI.this.updateInfoLabels();
            }
        });
        return button;
    }

    private void setSubtractModus(Display display, boolean subtractModus, boolean showDialog) {
        this.subtractModus = subtractModus;
        String fileName = this.subtractModus ? "org.eclipse.chemclipse.rcp.ui.icons/subtractScanActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/subtractScanDefault.gif";
        this.buttonSubtractOption.setImage(ApplicationImageFactory.getInstance().getImage(fileName, "16x16"));
        if (this.subtractModus && showDialog && this.preferenceStore.getBoolean("showSubtractDialog") && display != null) {
            SubtractScanWizard.openWizard(display.getActiveShell());
        }
    }

    private ScanFilterUI createScanFilterUI(Composite parent) {
        ScanFilterUI scanFilterUI = new ScanFilterUI(parent, 0);
        scanFilterUI.setLayoutData(new GridData(768));
        scanFilterUI.setUpdateListener(new IUpdateListener(){

            @Override
            public void update() {
                ExtendedScanChartUI.this.updateScan(ExtendedScanChartUI.this.scan);
            }
        });
        return scanFilterUI;
    }

    private ScanIdentifierUI createScanIdentifierUI(Composite parent) {
        final ScanIdentifierUI scanIdentifierUI = new ScanIdentifierUI(parent, 0);
        scanIdentifierUI.setLayoutData(new GridData(768));
        scanIdentifierUI.setUpdateListener(new IUpdateListener(){

            @Override
            public void update() {
                Display display = scanIdentifierUI.getDisplay();
                if (ExtendedScanChartUI.this.preferenceStore.getBoolean("leaveEditAfterIdentification")) {
                    ExtendedScanChartUI.this.setEditToolbarStatus(false);
                    ExtendedScanChartUI.this.setSubtractModus(display, false, false);
                    ExtendedScanChartUI.this.updateInfoLabels();
                }
                ExtendedScanChartUI.this.updateScan(ExtendedScanChartUI.this.scan);
                ExtendedScanChartUI.this.fireUpdateScan(display, ExtendedScanChartUI.this.scan);
                ExtendedScanChartUI.this.fireUpdateChromatogramSelection(display, null);
            }
        });
        return scanIdentifierUI;
    }

    private void subtractScanMSD(IScanMSD scanSource, IScanMSD scanSubtract) {
        MassSpectrumFilterSettings settings = new MassSpectrumFilterSettings();
        settings.setUseNominalMasses(PreferenceSupplier.isUseNominalMZ());
        settings.setUseNormalize(PreferenceSupplier.isUseNormalizedScan());
        settings.setSubtractMassSpectrum(PreferenceSupplier.getMassSpectrum((IScanMSD)scanSubtract));
        try {
            IScanMSD optimizedMassSpectrum = scanSource.getOptimizedMassSpectrum();
            if (optimizedMassSpectrum == null) {
                optimizedMassSpectrum = scanSource.makeDeepCopy();
                scanSource.setOptimizedMassSpectrum(optimizedMassSpectrum);
            }
            SubtractCalculator subtractCalculator = new SubtractCalculator();
            subtractCalculator.subtractMassSpectrum(optimizedMassSpectrum, settings);
        }
        catch (CloneNotSupportedException e) {
            logger.warn((Object)e);
        }
    }

    private Combo createDataType(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.setToolTipText("Data Type (MS, MS/MS, FID, DAD, ...)");
        combo.setItems(ScanDataSupport.DATA_TYPES_DEFAULT);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = combo.getText();
                ExtendedScanChartUI.this.scanChartUI.setDataType(DataType.valueOf((String)selection));
                ExtendedScanChartUI.this.updateScanChart(ExtendedScanChartUI.this.scan);
            }
        });
        return combo;
    }

    private Combo createSignalType(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        combo.setToolTipText("Signal Type (Centroid: Bar Series, Profile: Line Series)");
        combo.setItems(ScanDataSupport.SIGNAL_TYPES_DEFAULT);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = combo.getText();
                ExtendedScanChartUI.this.scanChartUI.setSignalType(SignalType.valueOf(selection));
                ExtendedScanChartUI.this.updateScanChart(ExtendedScanChartUI.this.scan);
            }
        });
        return combo;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedScanChartUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarTypes(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle type toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/types.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedScanChartUI.this.toolbarTypes);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/types.png", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/types.png", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarEdit(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the edit toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedScanChartUI.this.toolbarEdit);
                ExtendedScanChartUI.this.setEditToolbarStatus(visible);
                ExtendedScanChartUI.this.updateInfoLabels();
            }
        });
        return button;
    }

    private void setEditToolbarStatus(boolean visible) {
        boolean toolbarIsVisible;
        if (!visible && (toolbarIsVisible = this.toolbarEdit.isVisible())) {
            PartSupport.toggleCompositeVisibility((Composite)this.toolbarEdit);
        }
        this.editModus = visible;
        String fileName = visible ? "org.eclipse.chemclipse.rcp.ui.icons/editActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif";
        this.buttonEdit.setImage(ApplicationImageFactory.getInstance().getImage(fileName, "16x16"));
    }

    private void updateInfoLabels() {
        this.updateLabel(this.labelEdit, this.editModus ? "Edit On" : "");
        this.updateLabel(this.labelSubtract, this.subtractModus ? "Subtract On" : "");
        this.updateLabel(this.labelOptimized, this.isOptimizedScan() ? "Optimized" : "");
    }

    private boolean isMassSpectrum() {
        return this.scan instanceof IScanMSD;
    }

    private boolean isOptimizedScan() {
        IScanMSD optimizedMassSpectrum = this.getOptimizedScanMSD();
        return optimizedMassSpectrum != null;
    }

    private IScanMSD getScanMSD() {
        if (this.scan instanceof IScanMSD) {
            return (IScanMSD)this.scan;
        }
        return null;
    }

    private IScanMSD getOptimizedScanMSD() {
        IScanMSD optimizedMassSpectrum;
        IScanMSD scanMSD = this.getScanMSD();
        if (scanMSD != null && (optimizedMassSpectrum = scanMSD.getOptimizedMassSpectrum()) != null) {
            return optimizedMassSpectrum;
        }
        return null;
    }

    private void updateLabel(CLabel label, String message) {
        label.setText(message);
        if ("".equals(message)) {
            label.setBackground(this.backgroundDefault);
        } else {
            label.setBackground(Colors.YELLOW);
        }
    }

    private void updateButtons() {
        boolean enabled = this.isMassSpectrum();
        this.buttonCopyTraces.setEnabled(enabled);
        this.buttonSave.setEnabled(enabled);
        this.buttonDeleteOptimized.setEnabled(enabled && this.isOptimizedScan());
        this.buttonSubtractOption.setEnabled(enabled);
        this.scanFilterUI.setEnabled(enabled);
        this.scanIdentifierUI.setEnabled(enabled);
    }

    private Button createButtonCopyTracesClipboard(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Copy the traces to clipboard.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/copy-clipboard.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IScanMSD scanMSD = ExtendedScanChartUI.this.getScanMSD();
                int maxCopyTraces = ExtendedScanChartUI.this.preferenceStore.getInt("maxCopyScanTraces");
                String traces = ExtendedScanChartUI.this.scanDataSupport.extractTracesText(scanMSD, maxCopyTraces);
                TextTransfer textTransfer = TextTransfer.getInstance();
                Object[] data = new Object[]{traces};
                Transfer[] dataTypes = new Transfer[]{textTransfer};
                Clipboard clipboard = new Clipboard(e.widget.getDisplay());
                clipboard.setContents(data, dataTypes);
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the scan");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanChartUI.this.setEditToolbarStatus(false);
                ExtendedScanChartUI.this.setSubtractModus(e.display, false, false);
                ExtendedScanChartUI.this.updateInfoLabels();
                ExtendedScanChartUI.this.updateScan(ExtendedScanChartUI.this.scan);
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageScans()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageSubtract()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedScanChartUI.this.updateScan(ExtendedScanChartUI.this.scan);
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save the scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedScanChartUI.this.scan instanceof IScanMSD) {
                        IScanMSD scanMSD = (IScanMSD)ExtendedScanChartUI.this.scan;
                        DatabaseFileSupport.saveMassSpectrum((Shell)e.display.getActiveShell(), (IScanMSD)scanMSD, (String)"OriginalScan");
                        IScanMSD optimizedScan = scanMSD.getOptimizedMassSpectrum();
                        if (optimizedScan != null) {
                            DatabaseFileSupport.saveMassSpectrum((Shell)e.display.getActiveShell(), (IScanMSD)optimizedScan, (String)"OptimizedScan");
                        }
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private Button createDeleteOptimizedButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Delete the optimized scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanChartUI.this.deleteOptimizedScan(e.widget.getDisplay());
            }
        });
        return button;
    }

    private void deleteOptimizedScan(Display display) {
        if (this.scan instanceof IScanMSD && MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)"Optimized Scan", (String)"Would you like to delete the optimized scan?")) {
            IScanMSD scanMSD = (IScanMSD)this.scan;
            scanMSD.setOptimizedMassSpectrum(null);
            this.updateScan(this.scan);
        }
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelScan = new Label(composite, 0);
        this.labelScan.setText("");
        this.labelScan.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private ScanChartUI createScanChart(Composite parent) {
        ScanChartUI scanChartUI = new ScanChartUI(parent, 2048);
        scanChartUI.setLayoutData(new GridData(1808));
        return scanChartUI;
    }

    private void setDetectorSignalType(IScan scan) {
        if (scan instanceof IScanMSD) {
            this.setSelectionIndex(this.comboDataType, ScanDataSupport.DATA_TYPES_MSD);
            this.setSelectionIndex(this.comboSignalType, ScanDataSupport.SIGNAL_TYPES_MSD);
        } else if (scan instanceof IScanCSD) {
            this.setSelectionIndex(this.comboDataType, ScanDataSupport.DATA_TYPES_CSD);
            this.setSelectionIndex(this.comboSignalType, ScanDataSupport.SIGNAL_TYPES_CSD);
        } else if (scan instanceof IScanWSD) {
            this.setSelectionIndex(this.comboDataType, ScanDataSupport.DATA_TYPES_WSD);
            this.setSelectionIndex(this.comboSignalType, ScanDataSupport.SIGNAL_TYPES_WSD);
        } else {
            this.comboDataType.setItems(ScanDataSupport.DATA_TYPES_DEFAULT);
            this.comboDataType.select(0);
            this.comboSignalType.setItems(ScanDataSupport.SIGNAL_TYPES_DEFAULT);
            this.comboSignalType.select(0);
        }
        this.scanChartUI.setDataType(DataType.valueOf((String)this.comboDataType.getText()));
        this.scanChartUI.setSignalType(SignalType.valueOf(this.comboSignalType.getText()));
    }

    private void setSelectionIndex(Combo combo, String[] items) {
        int index = combo.getSelectionIndex() == -1 ? 0 : (combo.getSelectionIndex() < items.length ? combo.getSelectionIndex() : 0);
        combo.setItems(items);
        combo.select(index);
    }

    private void fireUpdateScan(Display display, final IScan scan) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ExtendedScanChartUI.this.eventBroker != null) {
                    ExtendedScanChartUI.this.eventBroker.send("scan/xxd/update/selection", (Object)scan);
                }
            }
        });
    }

    private void fireUpdateChromatogramSelection(Display display, final IScan scan) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IChromatogramSelection chromatogramSelection;
                Object object;
                DataUpdateSupport dataUpdateSupport;
                List<Object> objects;
                if (ExtendedScanChartUI.this.eventBroker != null && (objects = (dataUpdateSupport = Activator.getDefault().getDataUpdateSupport()).getUpdates("chromatogram/xxd/load/chromatogramselection")) != null && objects.size() > 0 && (object = objects.get(0)) instanceof IChromatogramSelection && (chromatogramSelection = (IChromatogramSelection)object) != null) {
                    int retentionTime;
                    int scanNumber;
                    IChromatogram chromatogram;
                    IScan scanReference;
                    if (scan != null && scan == (scanReference = (chromatogram = chromatogramSelection.getChromatogram()).getScan(scanNumber = chromatogram.getScanNumber(retentionTime = scan.getRetentionTime())))) {
                        chromatogramSelection.setSelectedScan(scan);
                    }
                    chromatogramSelection.update(false);
                }
            }
        });
    }
}

