/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReports;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.IChromatogramReportSupplier;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedChromatogramUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.menu.AbstractChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class ReportMenuEntry
extends AbstractChartMenuEntry
implements IChartMenuEntry {
    private ExtendedChromatogramUI extendedChromatogramUI;
    private IChromatogramReportSupplier chromatogramReportSupplier;
    private String type;

    public ReportMenuEntry(ExtendedChromatogramUI extendedChromatogramUI, IChromatogramReportSupplier chromatogramReportSupplier, String type) {
        this.extendedChromatogramUI = extendedChromatogramUI;
        this.chromatogramReportSupplier = chromatogramReportSupplier;
        this.type = type;
    }

    public String getCategory() {
        return "Reports";
    }

    public String getName() {
        return this.chromatogramReportSupplier.getReportName();
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        IChromatogram chromatogram;
        File file;
        IChromatogramSelection chromatogramSelection = this.extendedChromatogramUI.getChromatogramSelection();
        if (chromatogramSelection != null && (file = this.getFileFromFileDialog((chromatogram = chromatogramSelection.getChromatogram()).getName(), this.chromatogramReportSupplier)) != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    switch (ReportMenuEntry.this.type) {
                        case "TYPE_GENERIC": {
                            ChromatogramReports.generate((File)file, (boolean)false, (IChromatogram)chromatogram, (String)ReportMenuEntry.this.chromatogramReportSupplier.getId(), (IProgressMonitor)monitor);
                        }
                    }
                }
            };
            this.extendedChromatogramUI.processChromatogram(runnable);
        }
    }

    private File getFileFromFileDialog(String defaultFileName, IChromatogramReportSupplier chromatogramReportSupplier) {
        FileDialog fileDialog = new FileDialog(DisplayUtils.getShell(), 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText("Report");
        fileDialog.setFileName(defaultFileName);
        fileDialog.setFilterExtensions(new String[]{"*" + chromatogramReportSupplier.getFileExtension()});
        fileDialog.setFilterNames(new String[]{chromatogramReportSupplier.getReportName()});
        String fileName = fileDialog.open();
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        return new File(fileName);
    }
}

