/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.rcp.app.ui.dialogs.PerspectiveChooserDialog;
import org.eclipse.chemclipse.rcp.app.ui.dialogs.PerspectiveSwitcherDialog;
import org.eclipse.chemclipse.rcp.app.ui.internal.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.rcp.app.ui.switcher.PerspectiveSwitcher;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PerspectiveSwitchHandler {
    @Inject
    private static MApplication application;
    private static PerspectiveSwitcher perspectiveSwitcher;

    @Execute
    public void execute(MWindow window) {
        PerspectiveSwitcherDialog perspectiveSwitcherDialog = (PerspectiveSwitcherDialog)((Object)ContextInjectionFactory.make(PerspectiveSwitcherDialog.class, (IEclipseContext)window.getContext()));
        perspectiveSwitcherDialog.open();
    }

    public static void focusPerspectiveAndView(String perspectiveId, String viewId) {
        ArrayList<String> viewIds = new ArrayList<String>();
        viewIds.add(viewId);
        PerspectiveSwitchHandler.focusPerspectiveAndView(perspectiveId, viewIds);
    }

    public static void focusViews(List<String> viewIds) {
        PerspectiveSwitchHandler.focusPerspectiveAndView(null, viewIds);
    }

    public static void focusPerspectiveAndView(String perspectiveId, List<String> viewIds) {
        boolean changePerspectiveAutomatically = PreferenceSupplier.getChangePerspectiveAutomatically();
        if (!changePerspectiveAutomatically && PerspectiveSwitchHandler.showPerspectiveDialog() != 0) {
            return;
        }
        if (changePerspectiveAutomatically) {
            MWindow window;
            if (perspectiveSwitcher == null && application != null && (window = (MWindow)application.getChildren().get(0)) != null) {
                IEclipseContext context = window.getContext();
                perspectiveSwitcher = (PerspectiveSwitcher)ContextInjectionFactory.make(PerspectiveSwitcher.class, (IEclipseContext)context);
            }
            if (perspectiveId != null) {
                perspectiveSwitcher.changePerspective(perspectiveId);
            }
            for (String viewId : viewIds) {
                perspectiveSwitcher.focusView(viewId);
            }
        }
    }

    public static boolean isActivePerspective(String perspectiveId) {
        return ModelSupportAddon.getActivePerspective().equals(perspectiveId);
    }

    private static int showPerspectiveDialog() {
        Shell shell = Display.getCurrent().getActiveShell();
        String title = "Change Perspective";
        String message = "The program changes the perspectives and views automatically on certain tasks. You can select whether you would like to change perspectives automatically. If not, you are responsible by your own to select the needed perspective and views.";
        PerspectiveChooserDialog dialog = new PerspectiveChooserDialog(shell, title, message);
        return dialog.open();
    }
}

