/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.peak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.msd.converter.peak.IPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.msd.converter.peak.PeakExportSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakConverterMSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Export";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        List exportSupplier = PeakConverterMSD.getPeakConverterSupport().getExportSupplier();
        for (ISupplier supplier : exportSupplier) {
            IPeakExportConverter converter = PeakConverterMSD.getPeakExportConverter(supplier.getId());
            if (converter == null) continue;
            list.add((IProcessSupplier<?>)new PeakConverterMSDProcessSupplier(supplier, converter, this));
        }
        return list;
    }

    private static final class PeakConverterMSDProcessSupplier
    extends AbstractProcessSupplier<PeakExportSettings>
    implements IChromatogramSelectionProcessSupplier<PeakExportSettings> {
        private final IPeakExportConverter converter;
        private final ISupplier supplier;

        public PeakConverterMSDProcessSupplier(ISupplier supplier, IPeakExportConverter converter, IProcessTypeSupplier parent) {
            super("PeakConverterMSD." + supplier.getId(), supplier.getFilterName(), supplier.getDescription(), PeakExportSettings.class, parent, new DataCategory[]{DataCategory.MSD});
            this.supplier = supplier;
            this.converter = converter;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, PeakExportSettings processSettings, ProcessExecutionContext context) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD msd = (IChromatogramMSD)chromatogram;
                IProcessingInfo<?> info = this.converter.convert(processSettings.getExportFileName(this.supplier.getFileExtension(), chromatogram), (IPeaks<? extends IPeakMSD>)msd.toPeaks(msd.getName(), chromatogramSelection), false, context.getProgressMonitor());
                context.addMessages(info);
            } else {
                context.addWarnMessage(this.getName(), "Can only export MSD Data, skipping...");
            }
            return chromatogramSelection;
        }
    }
}

