/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.detector;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.PeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.support.BackfoldingDetectorSlope;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.support.BackfoldingDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.support.IBackfoldingDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorSettingsMSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IDetectorSlope;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.RawPeak;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.miscellaneous.Evaluation;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;

public class PeakDetectorSupport {
    private static float NORMALIZATION_BASE = 100000.0f;
    private static int CONSECUTIVE_SCAN_STEPS = 3;
    private static WindowSize MOVING_AVERAGE_WINDOW = WindowSize.WIDTH_5;
    private static double threshold = 0.005;

    private PeakDetectorSupport() {
    }

    public static IBackfoldingDetectorSlopes getBackfoldingSlopes(ITotalScanSignals totalIonSignals, IPeakDetectorSettingsMSD peakDetectorSettings) {
        PeakDetectorSupport.setDetectorSettings(peakDetectorSettings);
        return PeakDetectorSupport.getBackfoldingSlopes(totalIonSignals);
    }

    public static List<IRawPeak> getRawPeaks(IBackfoldingDetectorSlopes slopes, IPeakDetectorSettingsMSD peakDetectorSettings) {
        PeakDetectorSupport.setDetectorSettings(peakDetectorSettings);
        return PeakDetectorSupport.getRawPeaks(slopes);
    }

    private static void setDetectorSettings(IPeakDetectorSettingsMSD peakDetectorSettings) {
        if (peakDetectorSettings instanceof PeakDetectorSettings) {
            PeakDetectorSettings backfoldingPeakDetectorSettings = (PeakDetectorSettings)peakDetectorSettings;
            switch (backfoldingPeakDetectorSettings.getThreshold()) {
                case OFF: {
                    threshold = 5.0E-4;
                    break;
                }
                case LOW: {
                    threshold = 0.005;
                    break;
                }
                case MEDIUM: {
                    threshold = 0.05;
                    break;
                }
                case HIGH: {
                    threshold = 0.5;
                    break;
                }
                default: {
                    threshold = 0.005;
                }
            }
        }
    }

    private static IBackfoldingDetectorSlopes getBackfoldingSlopes(ITotalScanSignals totalIonSignals) {
        TotalScanSignalsModifier.normalize((ITotalScanSignals)totalIonSignals, (float)NORMALIZATION_BASE);
        int startScan = totalIonSignals.getStartScan();
        int stopScan = totalIonSignals.getStopScan();
        BackfoldingDetectorSlopes slopes = new BackfoldingDetectorSlopes(totalIonSignals);
        int scan = startScan;
        while (scan < stopScan) {
            ITotalScanSignal s1 = totalIonSignals.getTotalScanSignal(scan);
            ITotalScanSignal s2 = totalIonSignals.getNextTotalScanSignal(scan);
            if (s1 != null && s2 != null) {
                Point p1 = new Point((double)s1.getRetentionTime(), (double)s1.getTotalSignal());
                Point p2 = new Point((double)s2.getRetentionTime(), (double)s2.getTotalSignal());
                BackfoldingDetectorSlope slope = new BackfoldingDetectorSlope((IPoint)p1, (IPoint)p2, s1.getRetentionTime());
                slopes.add(slope);
            }
            ++scan;
        }
        slopes.calculateMovingAverage(MOVING_AVERAGE_WINDOW);
        return slopes;
    }

    private static List<IRawPeak> getRawPeaks(IBackfoldingDetectorSlopes slopes) {
        int size = slopes.size();
        int scanOffset = slopes.getStartScan() - 1;
        ArrayList<IRawPeak> rawPeaks = new ArrayList<IRawPeak>();
        int i = 1;
        while (i <= size - CONSECUTIVE_SCAN_STEPS) {
            int peakStop;
            int peakStart = PeakDetectorSupport.detectPeakStart(slopes, i, scanOffset);
            int peakMaximum = PeakDetectorSupport.detectPeakMaximum(slopes, peakStart, scanOffset);
            i = peakStop = PeakDetectorSupport.detectPeakStop(slopes, peakMaximum, scanOffset);
            RawPeak rawPeak = new RawPeak(peakStart += scanOffset, peakMaximum += scanOffset, peakStop += scanOffset);
            if (PeakDetectorSupport.isValidRawPeak((IRawPeak)rawPeak)) {
                rawPeak.setRetentionTimeAtMaximum(slopes.getDetectorSlope(peakMaximum).getRetentionTime());
                rawPeaks.add((IRawPeak)rawPeak);
            }
            ++i;
        }
        return rawPeaks;
    }

    private static boolean isValidRawPeak(IRawPeak rawPeak) {
        boolean isValid = false;
        int width = rawPeak.getStopScan() - rawPeak.getStartScan() + 1;
        if (width >= 3) {
            isValid = true;
        }
        return isValid;
    }

    private static int detectPeakStart(IBackfoldingDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakStart = size - 1;
        double[] values = new double[CONSECUTIVE_SCAN_STEPS];
        int scan = startScan;
        while (scan <= size - CONSECUTIVE_SCAN_STEPS) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() > threshold) {
                int j = 0;
                while (j < CONSECUTIVE_SCAN_STEPS) {
                    values[j] = slopes.getDetectorSlope(scan + j + scanOffset).getSlope();
                    ++j;
                }
                if (Evaluation.valuesAreGreaterThanThreshold((double[])values, (double)threshold) && Evaluation.valuesAreIncreasing((double[])values)) {
                    peakStart = scan;
                    break;
                }
            }
            ++scan;
        }
        return peakStart;
    }

    private static int detectPeakMaximum(IBackfoldingDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakMaximum = startScan;
        int scan = startScan;
        while (scan <= size - CONSECUTIVE_SCAN_STEPS) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() < 0.0) {
                peakMaximum = scan;
                break;
            }
            ++scan;
        }
        return peakMaximum;
    }

    private static int detectPeakStop(IBackfoldingDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakStop = size - CONSECUTIVE_SCAN_STEPS;
        int scan = startScan;
        while (scan <= size - CONSECUTIVE_SCAN_STEPS) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() > 0.0) {
                peakStop = scan;
                break;
            }
            ++scan;
        }
        return peakStop;
    }
}

