/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io;

import java.io.File;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.converter.quantitation.QuantDBConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DatabaseSupport {
    private static final Logger logger = Logger.getLogger(DatabaseSupport.class);

    public IQuantitationDatabase load() {
        IQuantitationDatabase quantitationDatabase = null;
        File file = new File(PreferenceSupplier.getSelectedQuantitationDatabase());
        if (file != null && file.exists()) {
            IProcessingInfo processingInfo = QuantDBConverter.convert((File)file, (IProgressMonitor)new NullProgressMonitor());
            quantitationDatabase = (IQuantitationDatabase)processingInfo.getProcessingResult();
        }
        return quantitationDatabase;
    }

    public void save(IQuantitationDatabase quantitationDatabase) {
        if (quantitationDatabase != null) {
            File file = quantitationDatabase.getFile();
            String converterId = quantitationDatabase.getConverterId();
            if (file != null && file.exists() && !"".equals(converterId)) {
                QuantDBConverter.convert((File)file, (IQuantitationDatabase)quantitationDatabase, (String)converterId, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

