/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.ui.internal.handlers.DetectorRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DetectorHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(DetectorHandler.class);
    private static IChromatogramSelection chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        if (chromatogramSelection != null) {
            DetectorRunnable runnable = new DetectorRunnable(chromatogramSelection);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)("Done: " + runnable.getDetectedPeaks() + " Peaks detected"));
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelection)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/csd/update/chromatogramselection") ? (IChromatogramSelection)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection") ? (IChromatogramSelection)event.getProperty("ChromatogramSelection") : null));
    }
}

