/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods.IMethodReader;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods.IMethodWriter;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class GenericStreamMethodFormat
implements IMethodWriter,
IMethodReader {
    private static final String MAGIC = "MTH";
    private final byte[] identifier;

    protected GenericStreamMethodFormat(String version) {
        this.identifier = ("MTH." + version).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public IProcessMethod convert(InputStream stream, String nameHint, MessageConsumer consumer, IProgressMonitor monitor) throws IOException {
        stream.mark(this.identifier.length);
        int i = 0;
        while (i < this.identifier.length) {
            int read = stream.read();
            if (read < 0 || (byte)(read & 0xFF) != this.identifier[i]) {
                stream.reset();
                return null;
            }
            ++i;
        }
        return this.deserialize(new GZIPInputStream(stream), consumer, monitor);
    }

    protected abstract IProcessMethod deserialize(InputStream var1, MessageConsumer var2, IProgressMonitor var3) throws IOException;

    protected abstract void serialize(OutputStream var1, IProcessMethod var2, MessageConsumer var3, IProgressMonitor var4) throws IOException;

    @Override
    public void convert(OutputStream stream, String nameHint, IProcessMethod processMethod, MessageConsumer messages, IProgressMonitor monitor) throws IOException {
        stream.write(this.identifier);
        GZIPOutputStream outputStream = new GZIPOutputStream(stream);
        this.serialize(outputStream, processMethod, messages, monitor);
        outputStream.finish();
        outputStream.flush();
        stream.flush();
    }
}

