/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ReaderHelper {
    public String getVersion(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        String version = this.getVersion(zipInputStream, "");
        zipInputStream.close();
        return version;
    }

    public String getVersion(Object object, String directoryPrefix) throws IOException {
        String entryName = String.valueOf(directoryPrefix) + "VERSION";
        String version = "";
        DataInputStream dataInputStream = null;
        if (object instanceof ZipInputStream) {
            dataInputStream = this.getDataInputStream((ZipInputStream)object, entryName);
        } else if (object instanceof ZipFile) {
            dataInputStream = this.getDataInputStream((ZipFile)object, entryName);
        }
        if (dataInputStream != null) {
            version = this.readString(dataInputStream);
        }
        return version;
    }

    public ZipInputStream getZipInputStream(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        return zipInputStream;
    }

    public DataInputStream getDataInputStream(ZipInputStream zipInputStream, String entryName) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String name;
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).equals(entryName)) continue;
            return new DataInputStream(zipInputStream);
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    public DataInputStream getDataInputStream(ZipFile zipFile, String entryName) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).equals(entryName)) continue;
            return new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    public String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }
}

