/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components.peaks;

import java.util.List;
import org.eclipse.chemclipse.model.support.PeakQuantitations;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.swt.ui.internal.provider.PeakQuantitationListLabelProvider;
import org.eclipse.chemclipse.swt.ui.internal.provider.PeakQuantitationListTableComparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;

public class PeakQuantitationListUI
extends ExtendedTableViewer {
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    private String[] titles = new String[]{"RT (Minutes)", "Area"};
    private int[] bounds = new int[]{100, 100};

    public PeakQuantitationListUI(Composite parent, int style) {
        super(parent, style);
        this.setColumns(this.titles, this.bounds);
    }

    public void update(PeakQuantitations peakQuantitations) {
        this.getTable().clearAll();
        if (peakQuantitations != null) {
            int[] bounds;
            String[] titles;
            List quantitationTitles = peakQuantitations.getTitles();
            int length = quantitationTitles.size();
            if (length == 0) {
                titles = this.titles;
                bounds = this.bounds;
            } else {
                titles = new String[length];
                bounds = new int[length];
                int i = 0;
                while (i < length) {
                    titles[i] = (String)quantitationTitles.get(i);
                    bounds[i] = 100;
                    ++i;
                }
            }
            this.setColumns(titles, bounds);
            this.setInput(peakQuantitations.getQuantitationEntries());
        } else {
            this.setInput(null);
        }
    }

    public void clear() {
        this.setInput(null);
    }

    private void setColumns(String[] titles, int[] bounds) {
        this.createColumns(titles, bounds);
        this.setLabelProvider((IBaseLabelProvider)new PeakQuantitationListLabelProvider());
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator((ViewerComparator)new PeakQuantitationListTableComparator());
    }
}

