/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.peak;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.IPeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.PeakFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.PeakFilterSupport;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakFilter {
    private static final Logger logger = Logger.getLogger(PeakFilter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.filter.peakFilterSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILTER = "filter";
    private static final String FILTER_SETTINGS = "filterSettings";
    private static final String PROCESSING_DESCRIPTION = "Peak Filter";
    private static final String NO_PEAK_FILTER_AVAILABLE = "There is no peak filter available.";

    private PeakFilter() {
    }

    public static IProcessingInfo<IPeakFilterResult> applyFilter(IPeakMSD peak, IPeakFilterSettings peakFilterSettings, String filterId, IProgressMonitor monitor) {
        return PeakFilter.applyFilter(Collections.singletonList(peak), peakFilterSettings, filterId, monitor);
    }

    public static IProcessingInfo<IPeakFilterResult> applyFilter(IPeakMSD peak, String filterId, IProgressMonitor monitor) {
        return PeakFilter.applyFilter(peak, null, filterId, monitor);
    }

    public static IProcessingInfo<IPeakFilterResult> applyFilter(List<IPeakMSD> peaks, IPeakFilterSettings peakFilterSettings, String filterId, IProgressMonitor monitor) {
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            return peakFilter.applyFilter(peaks, peakFilterSettings, monitor);
        }
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        return processingInfo;
    }

    public static IProcessingInfo<IPeakFilterResult> applyFilter(List<IPeakMSD> peaks, String filterId, IProgressMonitor monitor) {
        return PeakFilter.applyFilter(peaks, null, filterId, monitor);
    }

    public static IProcessingInfo<IPeakFilterResult> applyFilter(IChromatogramSelectionMSD chromatogramSelection, IPeakFilterSettings peakFilterSettings, String filterId, IProgressMonitor monitor) {
        return PeakFilter.applyFilter(Collections.unmodifiableList(((IChromatogramMSD)chromatogramSelection.getChromatogram()).getPeaks((IRetentionTimeRange)chromatogramSelection)), peakFilterSettings, filterId, monitor);
    }

    public static IProcessingInfo<IPeakFilterResult> applyFilter(IChromatogramSelectionMSD chromatogramSelection, String filterId, IProgressMonitor monitor) {
        return PeakFilter.applyFilter(chromatogramSelection, null, filterId, monitor);
    }

    public static IPeakFilterSupport getPeakFilterSupport() {
        IConfigurationElement[] extensions;
        PeakFilterSupport filterSupport = new PeakFilterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakFilterSupplier supplier = new PeakFilterSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            if (element.getAttribute(FILTER_SETTINGS) != null) {
                try {
                    IPeakFilterSettings instance = (IPeakFilterSettings)element.createExecutableExtension(FILTER_SETTINGS);
                    supplier.setSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.warn((Object)e);
                    supplier.setSettingsClass(null);
                }
            }
            filterSupport.add(supplier);
            ++n2;
        }
        return filterSupport;
    }

    private static IPeakFilter getPeakFilter(String filterId) {
        IConfigurationElement element = PeakFilter.getConfigurationElement(filterId);
        IPeakFilter instance = null;
        if (element != null) {
            try {
                instance = (IPeakFilter)element.createExecutableExtension(FILTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

