/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.process.files;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;

public class SupplierFileIdentifierCache
implements Function<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> {
    private ISupplierFileIdentifier[] fileIdentifiers = new ISupplierFileIdentifier[0];
    private Map<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> supplierCache;

    public SupplierFileIdentifierCache(final int maxFileSize) {
        this.supplierCache = new LinkedHashMap<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>>(maxFileSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> eldest) {
                return this.size() > maxFileSize;
            }
        };
    }

    public void setIdentifier(Collection<? extends ISupplierFileIdentifier> supplierFileIdentifier) {
        this.fileIdentifiers = supplierFileIdentifier.toArray(new ISupplierFileIdentifier[0]);
        this.refreshAll();
    }

    @Override
    public Map<ISupplierFileIdentifier, Collection<ISupplier>> apply(File file) {
        Map<ISupplierFileIdentifier, Collection<ISupplier>> list = this.supplierCache.get(file);
        if (list == null) {
            list = new LinkedHashMap<ISupplierFileIdentifier, Collection<ISupplier>>();
            ISupplierFileIdentifier[] iSupplierFileIdentifierArray = this.fileIdentifiers;
            int n = this.fileIdentifiers.length;
            int n2 = 0;
            while (n2 < n) {
                ISupplierFileIdentifier supplierFileIdentifier = iSupplierFileIdentifierArray[n2];
                Collection supplier = supplierFileIdentifier.getSupplier(file);
                if (!supplier.isEmpty()) {
                    list.put(supplierFileIdentifier, Collections.unmodifiableCollection(supplier));
                }
                ++n2;
            }
            list = Collections.unmodifiableMap(list);
            this.supplierCache.put(file, list);
        }
        return list;
    }

    public void refreshAll() {
        this.supplierCache.clear();
    }

    public void refresh(File file) {
        this.supplierCache.remove(file);
    }
}

