/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.baseline;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineSegment;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;

public class BaselineSegment
implements IBaselineSegment {
    private static final Logger logger = Logger.getLogger(BaselineSegment.class);
    private int startRetentionTime = 0;
    private float startBackgroundAbundance = 0.0f;
    private int stopRetentionTime = 0;
    private float stopBackgroundAbundance = 0.0f;

    public BaselineSegment(int startRetentionTime, int stopRetentionTime) {
        if (startRetentionTime > stopRetentionTime) {
            int tmp = startRetentionTime;
            startRetentionTime = stopRetentionTime;
            stopRetentionTime = tmp;
        }
        this.setStopRetentionTime(stopRetentionTime);
        this.setStartRetentionTime(startRetentionTime);
    }

    @Override
    public float getStartBackgroundAbundance() {
        return this.startBackgroundAbundance;
    }

    @Override
    public int getStartRetentionTime() {
        return this.startRetentionTime;
    }

    @Override
    public float getStopBackgroundAbundance() {
        return this.stopBackgroundAbundance;
    }

    @Override
    public int getStopRetentionTime() {
        return this.stopRetentionTime;
    }

    @Override
    public void setStartBackgroundAbundance(float startBackgroundAbundance) {
        this.startBackgroundAbundance = startBackgroundAbundance;
    }

    @Override
    public void setStartRetentionTime(int startRetentionTime) {
        if (startRetentionTime >= 0 && startRetentionTime <= this.stopRetentionTime) {
            this.startRetentionTime = startRetentionTime;
        } else {
            logger.warn((Object)("The start retention time must be lower or equal than the stop retention time. start: " + startRetentionTime + " - " + "stop: " + this.stopRetentionTime));
        }
    }

    @Override
    public void setStopBackgroundAbundance(float stopBackgroundAbundance) {
        this.stopBackgroundAbundance = stopBackgroundAbundance;
    }

    @Override
    public void setStopRetentionTime(int stopRetentionTime) {
        if (stopRetentionTime >= 0 && stopRetentionTime >= this.startRetentionTime) {
            this.stopRetentionTime = stopRetentionTime;
        } else {
            logger.warn((Object)("The stop retention time must be higher or equal than the start retention time. start: " + this.startRetentionTime + " - " + "stop: " + stopRetentionTime));
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BaselineSegment otherSegment = (BaselineSegment)other;
        return this.getStartBackgroundAbundance() == otherSegment.getStartBackgroundAbundance() && this.getStartRetentionTime() == otherSegment.getStartRetentionTime() && this.getStopBackgroundAbundance() == otherSegment.getStopBackgroundAbundance() && this.getStopRetentionTime() == otherSegment.getStopRetentionTime();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.startRetentionTime).hashCode() + 11 * Float.valueOf(this.startBackgroundAbundance).hashCode() + 13 * Integer.valueOf(this.stopRetentionTime).hashCode() + 11 * Float.valueOf(this.stopBackgroundAbundance).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startRetentionTime = " + this.startRetentionTime);
        builder.append(",");
        builder.append("startBackgroundAbundance = " + this.startBackgroundAbundance);
        builder.append(",");
        builder.append("stopRetentionTime = " + this.stopRetentionTime);
        builder.append(",");
        builder.append("stopBackgroundAbundance = " + this.stopBackgroundAbundance);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public float getBackgroundAbundance(int retentionTime) {
        Point p1 = new Point((double)this.startRetentionTime, (double)this.startBackgroundAbundance);
        Point p2 = new Point((double)this.stopRetentionTime, (double)this.stopBackgroundAbundance);
        return (float)Equations.createLinearEquation((IPoint)p1, (IPoint)p2).calculateY((double)retentionTime);
    }
}

