/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.supplier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.filter.IMeasurementFilter;
import org.eclipse.chemclipse.model.supplier.IMeasurementProcessSupplier;
import org.eclipse.chemclipse.processing.ProcessorFactory;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IProcessTypeSupplier.class})
public class IMeasurementFilterProcessTypeSupplier
implements IProcessTypeSupplier {
    private ProcessorFactory processorFactory;

    public String getCategory() {
        return "Filter";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList list = new ArrayList();
        Collection filters = this.processorFactory.getProcessors(ProcessorFactory.genericClass(IMeasurementFilter.class), null);
        for (IMeasurementFilter filter : filters) {
            list.add(new MeasurementFilterProcessSupplier(filter, this));
        }
        return list;
    }

    @Reference(unbind="-")
    public void setProcessorFactory(ProcessorFactory factory) {
        this.processorFactory = factory;
    }

    public static String getID(IMeasurementFilter<?> filter) {
        return "MeasurementFilter:" + filter.getID();
    }

    private static final class MeasurementFilterProcessSupplier<SettingsClass>
    extends AbstractProcessSupplier<SettingsClass>
    implements IMeasurementProcessSupplier<SettingsClass> {
        private final IMeasurementFilter<SettingsClass> filter;

        public MeasurementFilterProcessSupplier(IMeasurementFilter<SettingsClass> filter, IProcessTypeSupplier parent) {
            super(IMeasurementFilterProcessTypeSupplier.getID(filter), filter.getName(), filter.getDescription(), filter.getConfigClass(), parent, filter.getDataCategories());
            this.filter = filter;
        }

        @Override
        public Collection<? extends IMeasurement> applyProcessor(Collection<? extends IMeasurement> measurements, SettingsClass processSettings, ProcessExecutionContext context) {
            if (this.filter.acceptsIMeasurements(measurements)) {
                return (Collection)this.filter.filterIMeasurements(measurements, processSettings, Function.identity(), (MessageConsumer)context, context.getProgressMonitor());
            }
            ArrayList<IMeasurement> resultList = new ArrayList<IMeasurement>();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)context.getProgressMonitor(), (int)measurements.size());
            int unprocessed = 0;
            for (IMeasurement iMeasurement : measurements) {
                Set<IMeasurement> singleItem = Collections.singleton(iMeasurement);
                if (this.filter.acceptsIMeasurements(singleItem)) {
                    resultList.addAll((Collection)this.filter.filterIMeasurements(singleItem, processSettings, Function.identity(), (MessageConsumer)context, (IProgressMonitor)subMonitor.split(1)));
                    continue;
                }
                resultList.add(iMeasurement);
                subMonitor.worked(1);
                context.addWarnMessage(this.getName(), "measurement " + iMeasurement.getDataName() + " is incompatible with this filter");
                ++unprocessed;
            }
            if (unprocessed > 0) {
                context.addWarnMessage(this.getName(), String.valueOf(unprocessed) + " measurement(s) are skipped because they are incompatible with this filter");
            }
            return resultList;
        }
    }
}

