/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.support.AnalysisSegment;
import org.eclipse.chemclipse.model.support.ChromatogramSegment;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IAnalysisSupport;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.SegmentWidth;

public class AnalysisSupport
implements IAnalysisSupport {
    private List<IAnalysisSegment> analysisSegments;

    public AnalysisSupport(int numberOfScans, int segmentWidth) throws AnalysisSupportException {
        if (segmentWidth < 3 || numberOfScans < segmentWidth) {
            throw new AnalysisSupportException("The segmentWidth must be >= 3 and the number of scans must be >= segmentWidth.");
        }
        this.analysisSegments = AnalysisSupport.initializeAnalysisSegments(numberOfScans, 1, segmentWidth, SimpleSegment::new);
    }

    public AnalysisSupport(IScanRange scanRange, int segmentWidth) throws AnalysisSupportException {
        if (scanRange == null) {
            throw new AnalysisSupportException("The scan range must not be null.");
        }
        if (segmentWidth < 3 || scanRange.getWidth() < segmentWidth) {
            throw new AnalysisSupportException("The segmentWidth must be >= 3 and the number of scans must be >= segmentWidth.");
        }
        this.analysisSegments = AnalysisSupport.initializeAnalysisSegments(scanRange.getWidth(), scanRange.getStartScan(), segmentWidth, SimpleSegment::new);
    }

    @Override
    public int getNumberOfAnalysisSegments() {
        return this.analysisSegments.size();
    }

    @Override
    public List<IAnalysisSegment> getAnalysisSegments() {
        return this.analysisSegments;
    }

    private static <X extends IAnalysisSegment> List<X> initializeAnalysisSegments(int numberOfScans, int startScan, int segmentWidth, BiFunction<Integer, Integer, X> constructor) {
        assert (numberOfScans > 0) : "The number of scans must be > 0";
        assert (segmentWidth > 0) : "The segment width must be > 0";
        boolean addLastSegment = false;
        int lastSegmentWidth = numberOfScans % segmentWidth;
        if (lastSegmentWidth > 0) {
            addLastSegment = true;
        }
        int segmentParts = (numberOfScans -= lastSegmentWidth) / segmentWidth;
        ArrayList<IAnalysisSegment> analysisSegments = new ArrayList<IAnalysisSegment>();
        int i = 1;
        while (i <= segmentParts) {
            analysisSegments.add((IAnalysisSegment)constructor.apply(startScan, segmentWidth));
            startScan += segmentWidth;
            ++i;
        }
        if (addLastSegment) {
            analysisSegments.add((IAnalysisSegment)constructor.apply(startScan, lastSegmentWidth));
        }
        return analysisSegments;
    }

    public static List<ChromatogramSegment> getChromatogramSegments(IChromatogram<?> chromatogram, SegmentWidth segmentWidth) {
        return AnalysisSupport.initializeAnalysisSegments(chromatogram.getNumberOfScans(), 1, segmentWidth.getWidth(), (startScan, segmentWidth1) -> new ChromatogramAnalysisSegment(chromatogram, (int)startScan, (int)segmentWidth1));
    }

    private static final class ChromatogramAnalysisSegment
    extends AnalysisSegment
    implements ChromatogramSegment {
        private final IChromatogram<?> chromatogram;

        public ChromatogramAnalysisSegment(IChromatogram<?> chromatogram, int startScan, int segmentWidth) {
            super(startScan, segmentWidth);
            this.chromatogram = chromatogram;
        }

        @Override
        public IChromatogram<?> getChromatogram() {
            return this.chromatogram;
        }

        @Override
        public int getStartRetentionTime() {
            IScan scan = this.chromatogram.getScan(this.getStartScan());
            if (scan == null) {
                return -1;
            }
            return scan.getRetentionTime();
        }

        @Override
        public int getStopRetentionTime() {
            IScan scan = this.chromatogram.getScan(this.getStopScan());
            if (scan == null) {
                return -1;
            }
            return scan.getRetentionTime();
        }
    }

    private static final class SimpleSegment
    extends AnalysisSegment {
        public SimpleSegment(int startScan, int segmentWidth) {
            super(startScan, segmentWidth);
        }

        @Override
        public int getStartRetentionTime() {
            return -1;
        }

        @Override
        public int getStopRetentionTime() {
            return -1;
        }
    }
}

