/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.editors.EditorDescriptor;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class DataExplorerLabelProvider
extends LabelProvider
implements ILabelProvider,
IDescriptionProvider {
    ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final Function<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> supplierFunction;

    public DataExplorerLabelProvider(Function<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> identifier) {
        this.supplierFunction = identifier;
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof File) {
            File file = (File)anElement;
            String name = file.getName().equals("") ? file.getAbsolutePath() : file.getName();
            return "This is: " + name;
        }
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            ImageDescriptor descriptor = null;
            if (file.getName().equals("") || file.getParent() == null) {
                descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/drive.gif", "16x16");
            } else {
                Map<ISupplierFileIdentifier, Collection<ISupplier>> map = this.supplierFunction.apply(file);
                block0: for (Collection<ISupplier> suppliers : map.values()) {
                    for (ISupplier supplier : suppliers) {
                        ImageDescriptor imageDescriptor;
                        EditorDescriptor editorDescriptor = (EditorDescriptor)Adapters.adapt((Object)supplier, EditorDescriptor.class);
                        if (editorDescriptor == null || (imageDescriptor = editorDescriptor.getImageDescriptor()) == null) continue;
                        descriptor = imageDescriptor;
                        continue block0;
                    }
                }
                if (descriptor == null) {
                    Set<ISupplierFileIdentifier> identifier = map.keySet();
                    for (ISupplierFileIdentifier fileIdentifier : identifier) {
                        descriptor = this.getImageDescriptor(fileIdentifier, file);
                        if (descriptor != null) break;
                    }
                }
                if (descriptor == null) {
                    descriptor = file.isDirectory() ? ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/folder_opened.gif", "16x16") : ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/file.gif", "16x16");
                }
            }
            if (descriptor != null) {
                return (Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor);
            }
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(ISupplierFileIdentifier supplierFileIdentifier, File file) {
        ImageDescriptor descriptor;
        block37: {
            descriptor = null;
            if (supplierFileIdentifier == null) break block37;
            switch (supplierFileIdentifier.getType()) {
                case "MSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/chromatogram-msd.gif", "16x16");
                    break;
                }
                case "SCAN_MSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/massSpectrumFile.gif", "16x16");
                    break;
                }
                case "DATABASE_MSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/massSpectrumDatabase.gif", "16x16");
                    break;
                }
                case "CSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/chromatogram-csd.gif", "16x16");
                    break;
                }
                case "WSD": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/chromatogram-wsd.gif", "16x16");
                    break;
                }
                case "NMR": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/scan-nmr.gif", "16x16");
                    break;
                }
                case "XIR": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/scan-xir.gif", "16x16");
                    break;
                }
                case "PCR": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/plate-pcr.gif", "16x16");
                    break;
                }
                case "SEQ": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/sequenceListDefault.gif", "16x16");
                    break;
                }
                case "MTH": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/method.gif", "16x16");
                    break;
                }
                case "QDB": {
                    descriptor = ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/database.gif", "16x16");
                    break;
                }
                default: {
                    descriptor = file.isDirectory() ? ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/folder_opened.gif", "16x16") : (file.isFile() ? ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/file.gif", "16x16") : ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/question.gif", "16x16"));
                }
            }
        }
        return descriptor;
    }

    public String getText(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            String name = file.getName().equals("") ? file.getAbsolutePath() : file.getName();
            return name;
        }
        return "";
    }
}

