/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.util.HashMap;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public interface ISupplierFileEditorSupport
extends ISupplierFileIdentifier {
    @Deprecated
    default public boolean openEditor(File file) {
        return this.openEditor(file, false);
    }

    @Deprecated
    public boolean openEditor(File var1, boolean var2);

    public boolean openEditor(File var1, ISupplier var2);

    default public void openOverview(File file) {
    }

    default public void openEditor(File file, Object object, String elementId, String contributionURI, String iconURI, String tooltip) {
        this.openEditor(file, object, elementId, contributionURI, iconURI, tooltip, false);
    }

    @Deprecated
    default public void openEditor(File file, Object object, String elementId, String contributionURI, String iconURI, String tooltip, boolean batch) {
        EModelService modelService = ModelSupportAddon.getModelService();
        MApplication application = ModelSupportAddon.getApplication();
        EPartService partService = ModelSupportAddon.getPartService();
        MWindow window = (MWindow)application.getChildren().get(0);
        application.getContext().set("activeChildContext", (Object)window.getContext());
        MPartStack partStack = (MPartStack)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
        MPart part = MBasicFactory.INSTANCE.createPart();
        part.getTags().add("removeOnHide");
        part.setElementId(elementId);
        part.setContributionURI(contributionURI);
        if (file == null) {
            if (object != null) {
                part.setObject(object);
                if (object instanceof IChromatogram) {
                    String type = "";
                    if (object instanceof IChromatogramMSD) {
                        type = " [MSD]";
                    } else if (object instanceof IChromatogramCSD) {
                        type = " [CSD]";
                    } else if (object instanceof IChromatogramWSD) {
                        type = " [WSD]";
                    }
                    part.setLabel(String.valueOf(((IChromatogram)object).getName()) + type);
                } else if (object instanceof IMassSpectra) {
                    part.setLabel(((IMassSpectra)object).getName());
                } else if (object instanceof IScanXIR) {
                    part.setLabel("FTIR");
                } else if (object instanceof IMeasurement) {
                    part.setLabel(((IMeasurement)object).getDataName());
                }
            } else {
                part.setObject(null);
                part.setLabel("No valid chromatogram/mass spectra data");
            }
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("File", file.getAbsolutePath());
            map.put("Batch", batch);
            part.setObject(map);
            part.setLabel(file.getName());
        }
        part.setIconURI(iconURI);
        part.setTooltip(tooltip);
        part.setCloseable(true);
        partStack.getChildren().add(part);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
    }
}

