/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.AbstractChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.results.ChromatogramSegmentation;
import org.eclipse.chemclipse.model.results.NoiseSegmentMeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.ImmutableZeroIon;
import org.eclipse.chemclipse.msd.model.implementation.IonTransitionSettings;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractChromatogramMSD
extends AbstractChromatogram<IChromatogramPeakMSD>
implements IChromatogramMSD {
    private static final long serialVersionUID = 6481555040060687480L;
    public static int DEFAULT_SEGMENT_WIDTH = 10;
    private static final Logger logger = Logger.getLogger(AbstractChromatogramMSD.class);
    private final IIonTransitionSettings ionTransitionSettings = new IonTransitionSettings();
    private INoiseCalculator noiseCalculator;
    private ImmutableZeroIon immutableZeroIon;

    public AbstractChromatogramMSD() {
        try {
            this.immutableZeroIon = new ImmutableZeroIon();
        }
        catch (AbundanceLimitExceededException | IonLimitExceededException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.loadNoiseCalculator();
    }

    private void loadNoiseCalculator() {
        NoiseSegmentMeasurementResult noiseResult = this.getMeasurementResult(NoiseSegmentMeasurementResult.class);
        String noiseCalculatorId = noiseResult != null ? noiseResult.getNoiseCalculatorId() : PreferenceSupplier.getSelectedNoiseCalculatorId();
        this.noiseCalculator = NoiseCalculator.getNoiseCalculator((String)noiseCalculatorId);
    }

    public void recalculateTheNoiseFactor() {
        this.loadNoiseCalculator();
    }

    public float getSignalToNoiseRatio(float abundance) {
        if (this.noiseCalculator != null) {
            return this.noiseCalculator.getSignalToNoiseRatio((IChromatogram)this, abundance);
        }
        return 0.0f;
    }

    @Override
    public int getNumberOfScanIons() {
        int amount = 0;
        for (IScan scan : this.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum)) continue;
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            amount += ms.getNumberOfIons();
        }
        return amount;
    }

    @Override
    public void enforceLoadScanProxies(IProgressMonitor monitor) {
        for (IScan scan : this.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum) || this.isUnloaded()) continue;
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            ms.enforceLoadScanProxy();
        }
    }

    public void fireUpdate(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
            ((ChromatogramSelectionMSD)chromatogramSelection).update(true);
        }
    }

    @Override
    public IScanMSD getScan(int scan, IMarkedIons excludedIons) {
        IVendorMassSpectrum supplierMassSpectrum = this.getSupplierScan(scan);
        if (supplierMassSpectrum == null) {
            return null;
        }
        return supplierMassSpectrum.getMassSpectrum(excludedIons);
    }

    @Override
    public IVendorMassSpectrum getSupplierScan(int scan) {
        IScan storedScan;
        int position = scan;
        if (position > 0 && position <= this.getScans().size() && (storedScan = (IScan)this.getScans().get(--position)) instanceof IVendorMassSpectrum) {
            return (IVendorMassSpectrum)storedScan;
        }
        return null;
    }

    @Override
    public float getMinIonAbundance() {
        float minAbundance = Float.MAX_VALUE;
        for (IScan scan : this.getScans()) {
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getLowestAbundance()) || !(ion.getAbundance() < minAbundance)) continue;
            minAbundance = ion.getAbundance();
        }
        return minAbundance;
    }

    @Override
    public float getMaxIonAbundance() {
        float maxAbundance = Float.MIN_VALUE;
        for (IScan scan : this.getScans()) {
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getHighestAbundance()) || !(ion.getAbundance() > maxAbundance)) continue;
            maxAbundance = ion.getAbundance();
        }
        return maxAbundance;
    }

    @Override
    public double getStartIon() {
        if (this.getScans().size() == 0) {
            return 0.0;
        }
        double lowestIon = Double.MAX_VALUE;
        for (IScan scan : this.getScans()) {
            double actualIon;
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getLowestIon()) || !((actualIon = ion.getIon()) < lowestIon)) continue;
            lowestIon = actualIon;
        }
        return lowestIon;
    }

    @Override
    public double getStopIon() {
        if (this.getScans().size() == 0) {
            return 0.0;
        }
        double highestIon = Double.MIN_VALUE;
        for (IScan scan : this.getScans()) {
            double actualIon;
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getHighestIon()) || !((actualIon = ion.getIon()) > highestIon)) continue;
            highestIon = actualIon;
        }
        return highestIon;
    }

    public double getPeakIntegratedArea() {
        double integratedArea = 0.0;
        for (IChromatogramPeakMSD peak : this.getPeaks()) {
            integratedArea += peak.getIntegratedArea();
        }
        return integratedArea;
    }

    @Override
    public IIonTransitionSettings getIonTransitionSettings() {
        return this.ionTransitionSettings;
    }

    private boolean isZeroImmutableIon(IIon ion) {
        return this.immutableZeroIon.equals(ion);
    }

    public <ResultType extends IMeasurementResult<?>> ResultType getMeasurementResult(Class<ResultType> type) {
        IMeasurementResult result = super.getMeasurementResult(type);
        if (result == null && type == ChromatogramSegmentation.class) {
            return (ResultType)((IMeasurementResult)type.cast(new ChromatogramSegmentation((IChromatogram)this, PreferenceSupplier.getDefaultSegmentWidth())));
        }
        return (ResultType)result;
    }

    public void addMeasurementResult(IMeasurementResult<?> chromatogramResult) {
        super.addMeasurementResult(chromatogramResult);
        if (chromatogramResult instanceof NoiseSegmentMeasurementResult) {
            this.recalculateTheNoiseFactor();
        }
    }
}

