/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonBounds;
import org.eclipse.chemclipse.msd.model.core.IIonProvider;
import org.eclipse.chemclipse.msd.model.core.IMassSpectrumCloneable;
import org.eclipse.chemclipse.msd.model.core.IMassSpectrumNormalizable;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public interface IScanMSD
extends IScan,
IMassSpectrumCloneable,
IMassSpectrumNormalizable,
IIonProvider {
    public float getTotalSignal(IMarkedIons var1);

    public IExtractedIonSignal getExtractedIonSignal();

    public IExtractedIonSignal getExtractedIonSignal(double var1, double var3);

    public double getBasePeak();

    public float getBasePeakAbundance();

    public IIon getLowestIon();

    public IIon getLowestAbundance();

    public IIon getHighestIon();

    public IIon getHighestAbundance();

    public IIonBounds getIonBounds();

    public IScanMSD addIons(List<IIon> var1, boolean var2);

    public IScanMSD addIon(IIon var1, boolean var2);

    public IScanMSD addIon(IIon var1);

    public IScanMSD addIon(boolean var1, IIon var2);

    public IScanMSD removeIon(IIon var1);

    public IScanMSD removeAllIons();

    public IScanMSD removeIons(IMarkedIons var1);

    public IScanMSD removeIon(int var1);

    public IScanMSD removeIons(Set<Integer> var1);

    public IIon getIon(int var1) throws AbundanceLimitExceededException, IonLimitExceededException;

    public IIon getIon(double var1) throws AbundanceLimitExceededException, IonLimitExceededException;

    public IIon getIon(double var1, int var3) throws AbundanceLimitExceededException, IonLimitExceededException;

    public void adjustIons(float var1);

    public IScanMSD getMassSpectrum(IMarkedIons var1);

    public boolean hasIons();

    public void enforceLoadScanProxy();

    public void setOptimizedMassSpectrum(IScanMSD var1);

    public IScanMSD getOptimizedMassSpectrum();

    public boolean isMeasurementSIM();

    public boolean isTandemMS();

    public boolean isHighResolutionMS();
}

