/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import java.util.List;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public interface IExtractedIonSignals {
    public IChromatogramMSD getChromatogram();

    public void add(IExtractedIonSignal var1);

    public void add(int var1, float var2, int var3, boolean var4);

    public IExtractedIonSignal getExtractedIonSignal(int var1) throws NoExtractedIonSignalStoredException;

    public List<IExtractedIonSignal> getExtractedIonSignals();

    public ITotalScanSignals getTotalIonSignals(int var1);

    public ITotalScanSignals getTotalIonSignals();

    public ITotalScanSignals getTotalIonSignals(int var1, IScanRange var2);

    public ITotalScanSignals getTotalIonSignals(IScanRange var1);

    public IScanMSD getScan(int var1);

    public IScanMSD getScan(int var1, IMarkedIons var2);

    public int getStartIon();

    public int getStopIon();

    public int size();

    public int getStartScan();

    public int getStopScan();

    public IExtractedIonSignals makeDeepCopyWithoutSignals();

    default public float[] getValues(IScanRange range, int ion) {
        float[] values = new float[range.getWidth()];
        int counter = 0;
        int scan = range.getStartScan();
        while (scan <= range.getStopScan()) {
            try {
                try {
                    IExtractedIonSignal signal = this.getExtractedIonSignal(scan);
                    if ((double)ion == 0.0) {
                        values[counter] = signal.getTotalSignal();
                        continue;
                    }
                    values[counter] = signal.getAbundance(ion);
                }
                catch (NoExtractedIonSignalStoredException e) {
                    values[counter] = 0.0f;
                    ++counter;
                }
            }
            finally {
                ++counter;
            }
        }
        return values;
    }
}

