/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.ChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.classifier.exceptions.NoChromatogramClassifierSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramClassifierProcessTypeSupport
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Classifier";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IChromatogramClassifierSupport support = ChromatogramClassifier.getChromatogramClassifierSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableClassifierIds()) {
                IChromatogramClassifierSupplier supplier = support.getClassifierSupplier(processorId);
                IChromatogramClassifier classifier = ChromatogramClassifier.getChromatogramClassifier(processorId);
                if (classifier == null || supplier == null) continue;
                list.add((IProcessSupplier<?>)new ChromatogramClassifierProcessorSupplier(supplier, classifier, this));
            }
            return list;
        }
        catch (NoChromatogramClassifierSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramClassifierProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramClassifierSettings> {
        private final IChromatogramClassifier classifier;

        public ChromatogramClassifierProcessorSupplier(IChromatogramClassifierSupplier supplier, IChromatogramClassifier classifier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getClassifierName(), supplier.getDescription(), supplier.getSettingsClass(), parent, classifier.getDataTypes());
            this.classifier = classifier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramClassifierSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            this.classifier.applyClassifier(chromatogramSelection, processSettings, monitor);
            return chromatogramSelection;
        }
    }
}

