/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.impl;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.impl.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.FilterSettingsSelection;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilterSelection
extends AbstractChromatogramFilter
implements IChromatogramFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof FilterSettingsSelection) {
            FilterSettingsSelection filterSettings = (FilterSettingsSelection)chromatogramFilterSettings;
            double startRT = filterSettings.getStartRetentionTimeMinutes() * 60000.0;
            double stopRT = filterSettings.getStopRetentionTimeMinutes() * 60000.0;
            if (Double.isInfinite(startRT)) {
                startRT = (double)chromatogramSelection.getChromatogram().getStartRetentionTime() * Math.signum(startRT);
            } else if (filterSettings.isStartRelative()) {
                startRT = (double)chromatogramSelection.getStartRetentionTime() + startRT;
            }
            if (Double.isInfinite(stopRT)) {
                stopRT = (double)chromatogramSelection.getChromatogram().getStopRetentionTime() * Math.signum(startRT);
            } else if (filterSettings.isStopRelative()) {
                stopRT = (double)chromatogramSelection.getStopRetentionTime() + stopRT;
            }
            chromatogramSelection.setRangeRetentionTime((int)startRT, (int)stopRT);
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Chromatogram Selection applied"));
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        FilterSettingsSelection filterSettings = PreferenceSupplier.getFilterSettingsSelection();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }
}

