/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.internal.core.IPeakMaxPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IBaselineSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.ISettingStatus;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.IonPercentages;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakMaxPeakIntegrator
implements IPeakMaxPeakIntegrator {
    @Override
    public IPeakIntegrationResult integrate(IPeak peak, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        this.validatePeak(peak);
        this.validateSettings((IIntegrationSettings)peakIntegrationSettings);
        PeakIntegrationResult result = null;
        IBaselineSupport baselineSupport = peakIntegrationSettings.getBaselineSupport();
        List<IIntegrationEntry> integrationEntries = this.calculateIntegratedArea(peak, baselineSupport, peakIntegrationSettings.getSelectedIons());
        peak.setIntegratedArea(integrationEntries, "PeakMax Integrator");
        ISettingStatus settingStatus = peakIntegrationSettings.getSettingStatus(peak);
        if (settingStatus.report()) {
            double integratedArea = this.calculateIntegratedArea(integrationEntries);
            result = this.getPeakIntegrationResult(peak, integratedArea, peakIntegrationSettings);
        }
        return result;
    }

    @Override
    public IPeakIntegrationResults integrate(List<? extends IPeak> peaks, IPeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        this.validatePeakList(peaks);
        this.validateSettings((IIntegrationSettings)peakIntegrationSettings);
        IPeakIntegrationResult peakIntegrationSumResult = null;
        PeakIntegrationResults peakIntegrationResults = new PeakIntegrationResults();
        int peakNumber = 1;
        for (IPeak iPeak : peaks) {
            IPeakIntegrationResult peakIntegrationResult;
            monitor.subTask("Integrate Peak " + peakNumber++);
            try {
                peakIntegrationResult = this.integrate(iPeak, peakIntegrationSettings, monitor);
            }
            catch (ValueMustNotBeNullException e) {
                continue;
            }
            ISettingStatus settingStatus = peakIntegrationSettings.getSettingStatus(iPeak);
            if (!settingStatus.report()) continue;
            if (settingStatus.sumOn()) {
                if (peakIntegrationSumResult == null) {
                    peakIntegrationSumResult = peakIntegrationResult;
                    this.resetIntegrationSumResultValues(peakIntegrationSumResult);
                    continue;
                }
                peakIntegrationSumResult.setStopRetentionTime(peakIntegrationResult.getStopRetentionTime());
                double integratedArea = peakIntegrationSumResult.getIntegratedArea() + peakIntegrationResult.getIntegratedArea();
                peakIntegrationSumResult.setIntegratedArea(integratedArea);
                continue;
            }
            if (peakIntegrationSumResult != null) {
                peakIntegrationResults.add(peakIntegrationSumResult);
                peakIntegrationSumResult = null;
            }
            peakIntegrationResults.add(peakIntegrationResult);
        }
        if (peakIntegrationSumResult != null) {
            peakIntegrationResults.add(peakIntegrationSumResult);
            peakIntegrationSumResult = null;
        }
        return peakIntegrationResults;
    }

    private void validatePeakList(List<? extends IPeak> peaks) throws ValueMustNotBeNullException {
        if (peaks == null) {
            throw new ValueMustNotBeNullException("The peak list must not be null.");
        }
    }

    private void validatePeak(IPeak peak) throws ValueMustNotBeNullException {
        if (peak == null) {
            throw new ValueMustNotBeNullException("The peak instance must not be null.");
        }
        if (peak.getPeakModel() == null) {
            throw new ValueMustNotBeNullException("The peak model must not be null.");
        }
    }

    private void validateSettings(IIntegrationSettings integrationSettings) throws ValueMustNotBeNullException {
        if (integrationSettings == null) {
            throw new ValueMustNotBeNullException("The integration settings must not be null.");
        }
    }

    private List<IIntegrationEntry> calculateIntegratedArea(IPeak peak, IBaselineSupport baselineSupport, IMarkedIons selectedIons) {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        IPeakModel peakModel = peak.getPeakModel();
        IScan scan = peakModel.getPeakMaximum();
        double integratedAreaTIC = this.calculateTICPeakArea(peak, baselineSupport);
        Set selectedIonsNominal = selectedIons.getIonsNominal();
        if (selectedIonsNominal.size() > 0 && !selectedIonsNominal.contains(AbstractIon.getIon((double)0.0)) && scan instanceof IScanMSD) {
            IonPercentages ionPercentages = new IonPercentages((IScanMSD)scan);
            for (Integer ion : selectedIonsNominal) {
                float correctionFactor = ionPercentages.getPercentage(ion.intValue()) / 100.0f;
                double integratedArea = integratedAreaTIC * (double)correctionFactor;
                IntegrationEntry integrationEntry = new IntegrationEntry((double)ion.intValue(), integratedArea);
                integrationEntries.add((IIntegrationEntry)integrationEntry);
            }
        } else {
            IntegrationEntry integrationEntry = new IntegrationEntry(integratedAreaTIC);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
        }
        return integrationEntries;
    }

    private double calculateTICPeakArea(IPeak peak, IBaselineSupport baselineSupport) {
        double integratedArea = 0.0;
        IPeakModel peakModel = peak.getPeakModel();
        integratedArea = peakModel.getPeakMaximum().getTotalSignal();
        if (integratedArea < 1.0) {
            integratedArea = 0.0;
        }
        return integratedArea;
    }

    private PeakIntegrationResult getPeakIntegrationResult(IPeak peak, double integratedArea, IPeakIntegrationSettings peakIntegrationSettings) {
        IMarkedIons selectedIons = peakIntegrationSettings.getSelectedIons();
        Set<Integer> integratedIons = this.getIntegratedIons(selectedIons);
        PeakIntegrationResult result = new PeakIntegrationResult();
        result.setIntegratedArea(integratedArea);
        result.setIntegratorType("PeakMax Integrator");
        result.setPeakType(peak.getPeakType().toString());
        float purity = 0.0f;
        float sn = 0.0f;
        if (peak instanceof IChromatogramPeakMSD) {
            IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)peak;
            purity = chromatogramPeak.getPurity();
            sn = chromatogramPeak.getSignalToNoiseRatio();
        } else if (peak instanceof IChromatogramPeakCSD) {
            IChromatogramPeakCSD chromatogramPeak = (IChromatogramPeakCSD)peak;
            sn = chromatogramPeak.getSignalToNoiseRatio();
        } else if (peak instanceof IChromatogramPeakWSD) {
            IChromatogramPeakWSD chromatogramPeak = (IChromatogramPeakWSD)peak;
            purity = chromatogramPeak.getPurity();
            sn = chromatogramPeak.getSignalToNoiseRatio();
        }
        result.setPurity(purity);
        result.setSN(sn);
        result.setStartRetentionTime(peak.getPeakModel().getStartRetentionTime());
        result.setStopRetentionTime(peak.getPeakModel().getStopRetentionTime());
        result.setTailing(peak.getPeakModel().getTailing());
        result.setWidth(peak.getPeakModel().getWidthByInflectionPoints());
        result.addIntegratedIons(integratedIons);
        return result;
    }

    private double calculateIntegratedArea(List<IIntegrationEntry> integrationEntries) {
        double result = 0.0;
        for (IIntegrationEntry integrationEntry : integrationEntries) {
            result += integrationEntry.getIntegratedArea();
        }
        return result;
    }

    private void resetIntegrationSumResultValues(IPeakIntegrationResult peakIntegrationSumResult) {
        peakIntegrationSumResult.setPeakType("Summed integrated area");
        peakIntegrationSumResult.setPurity(0.0f);
        peakIntegrationSumResult.setSN(0.0f);
        peakIntegrationSumResult.setTailing(0.0f);
        peakIntegrationSumResult.setWidth(0);
    }

    private Set<Integer> getIntegratedIons(IMarkedIons selectedIons) {
        HashSet<Integer> result = selectedIons == null ? new HashSet<Integer>() : selectedIons.getIonsNominal();
        return result;
    }
}

