/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.io.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.model.core.IChromatogramPeak;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.msd.converter.peak.IPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.peak.IPeakImportConverter;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonProvider;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.PeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class CSVPeakConverter
implements IPeakExportConverter,
IPeakImportConverter,
IMagicNumberMatcher {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String HEADER_NAME = "Name";
    private static final String HEADER_AREA = "Area";
    private static final String HEADER_RRT = "RRT (min)";
    private static final String HEADER_RI = "RI";
    private static final String HEADER_INTENSITIES = "intensities";
    private static final String HEADER_MZ = "m/z";
    private static final String HEADER_RT = "RT (min)";
    private static final char SEPERATOR_VALUE = ':';
    private static final char SEPERATOR_RECORD = ' ';
    private static final Pattern SEPERATOR_VALUE_PATTERN = Pattern.compile(String.valueOf(':'), 16);
    private static final Pattern SEPERATOR_RECORD_PATTERN = Pattern.compile(String.valueOf(' '), 16);
    private static final String NAME = "CSV Peak Export";
    private static final String[] HEADERS = new String[]{"Name", "RT (min)", "RRT (min)", "RI", "Area", "S/N", "CAS", "m/z", "intensities"};
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public IProcessingInfo<?> convert(File file, IPeaks<? extends IPeakMSD> peaks, boolean append, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(file, append);){
                CSVPeakConverter.writePeaks(peaks, new OutputStreamWriter((OutputStream)stream, CHARSET), !append);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ProcessingInfo error = new ProcessingInfo();
            error.addErrorMessage(NAME, "Export to CSV failed", (Throwable)e);
            return error;
        }
        return new ProcessingInfo((Object)file);
    }

    private static StringBuilder writeIntensities(IPeakModelMSD peakModel) {
        StringBuilder sb = new StringBuilder();
        if (peakModel != null) {
            List retentionTimes = peakModel.getRetentionTimes();
            for (Integer rt : retentionTimes) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(rt);
                sb.append(':');
                sb.append(peakModel.getPeakAbundance(rt.intValue()));
            }
        }
        return sb;
    }

    private static StringBuilder writeMassSpectrum(IIonProvider provider) {
        StringBuilder sb = new StringBuilder();
        if (provider != null) {
            for (IIon ion : provider.getIons()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(ion.getIon());
                sb.append(':');
                sb.append(ion.getAbundance());
            }
        }
        return sb;
    }

    private static <R> R getLibInfo(IIdentificationTarget target, Function<ILibraryInformation, R> fkt) {
        if (target != null) {
            ILibraryInformation information = target.getLibraryInformation();
            return fkt.apply(information);
        }
        return null;
    }

    public IProcessingInfo<IPeaks<?>> convert(File file, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream stream = new FileInputStream(file);){
                return new ProcessingInfo(CSVPeakConverter.readPeaks(new InputStreamReader((InputStream)stream, CHARSET)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            ProcessingInfo error = new ProcessingInfo();
            error.addErrorMessage(NAME, "Import failed", (Throwable)e);
            return error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePeaks(IPeaks<? extends IPeak> peaks, Writer writer, boolean writeHeader) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVPrinter csv = new CSVPrinter((Appendable)writer, CSVFormat.EXCEL.withNullString("").withQuoteMode(QuoteMode.ALL));){
            NumberFormat nf;
            if (writeHeader) {
                csv.printRecord(Arrays.asList(HEADERS));
            }
            DecimalFormat decimalFormat = NUMBER_FORMAT;
            synchronized (decimalFormat) {
                nf = (NumberFormat)NUMBER_FORMAT.clone();
            }
            for (IPeak peak : peaks.getPeaks()) {
                IIdentificationTarget target = IIdentificationTarget.getBestIdentificationTarget((Set)peak.getTargets());
                IPeakModel peakModel = peak.getPeakModel();
                String peakName = peak.getName();
                if (peakName == null) {
                    peakName = CSVPeakConverter.getLibInfo(target, ILibraryInformation::getName);
                }
                csv.print((Object)peakName);
                csv.print((Object)nf.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0));
                csv.print((Object)nf.format((double)peakModel.getPeakMaximum().getRelativeRetentionTime() / 60000.0));
                csv.print((Object)nf.format(peakModel.getPeakMaximum().getRetentionIndex()));
                csv.print((Object)nf.format(peak.getIntegratedArea()));
                if (peak instanceof IChromatogramPeak) {
                    csv.print((Object)nf.format(((IChromatogramPeak)peak).getSignalToNoiseRatio()));
                } else {
                    csv.print((Object)"-");
                }
                csv.print((Object)CSVPeakConverter.getLibInfo(target, ILibraryInformation::getCasNumber));
                if (peak instanceof IPeakMSD) {
                    IPeakMSD msd = (IPeakMSD)peak;
                    csv.print((Object)CSVPeakConverter.writeMassSpectrum((IIonProvider)msd.getPeakModel().getPeakMassSpectrum()));
                    csv.print((Object)CSVPeakConverter.writeIntensities(msd.getPeakModel()));
                }
                csv.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPeaks<IPeak> readPeaks(Reader reader) throws IOException, ParseException {
        Peaks result = new Peaks();
        Throwable throwable = null;
        Object var3_4 = null;
        try (CSVParser parser = new CSVParser(reader, CSVFormat.EXCEL.withHeader(HEADERS).withSkipHeaderRecord());){
            NumberFormat nf;
            DecimalFormat decimalFormat = NUMBER_FORMAT;
            synchronized (decimalFormat) {
                nf = (NumberFormat)NUMBER_FORMAT.clone();
            }
            for (CSVRecord record : parser) {
                PeakModelMSD peakModel = new PeakModelMSD(CSVPeakConverter.parseMassSpectrum(record.get(HEADER_MZ)), CSVPeakConverter.parseIntensityValues(record.get(HEADER_INTENSITIES)));
                IScan maximum = peakModel.getPeakMaximum();
                maximum.setRetentionTime((int)(nf.parse(record.get(HEADER_RT)).doubleValue() * 60000.0));
                maximum.setRelativeRetentionTime((int)(nf.parse(record.get(HEADER_RRT)).doubleValue() * 60000.0));
                maximum.setRetentionIndex(nf.parse(record.get(HEADER_RI)).floatValue());
                PeakMSD peakMSD = new PeakMSD((IPeakModelMSD)peakModel);
                peakMSD.setName(record.get(HEADER_NAME));
                peakMSD.addAllIntegrationEntries(new IIntegrationEntry[]{new IntegrationEntry(nf.parse(record.get(HEADER_AREA)).doubleValue())});
                result.addPeak((IPeak)peakMSD);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private static IPeakMassSpectrum parseMassSpectrum(String headerMz) {
        PeakMassSpectrum massSpectrum = new PeakMassSpectrum();
        SEPERATOR_RECORD_PATTERN.splitAsStream(headerMz).spliterator().forEachRemaining(record -> {
            String[] values = SEPERATOR_VALUE_PATTERN.split((CharSequence)record, 2);
            double ion = Double.parseDouble(values[0]);
            float intensity = Float.parseFloat(values[1]);
            try {
                massSpectrum.addIon((IIon)new Ion(ion, intensity));
            }
            catch (AbundanceLimitExceededException | IonLimitExceededException e) {
                throw new RuntimeException("can't read ion", e);
            }
        });
        return massSpectrum;
    }

    private static IPeakIntensityValues parseIntensityValues(String headerIntensity) {
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        SEPERATOR_RECORD_PATTERN.splitAsStream(headerIntensity).spliterator().forEachRemaining(record -> {
            String[] values = SEPERATOR_VALUE_PATTERN.split((CharSequence)record, 2);
            int rt = Integer.parseInt(values[0]);
            float abundance = Float.parseFloat(values[1]);
            intensityValues.addIntensityValue(rt, abundance);
        });
        intensityValues.normalize();
        return intensityValues;
    }

    public boolean checkFileFormat(File file) {
        return file.getName().toLowerCase().endsWith(".csv") && this.matchHeader(file);
    }

    private boolean matchHeader(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CSVParser parser = new CSVParser((Reader)new FileReader(file), CSVFormat.EXCEL.withHeader(new String[0]));){
                Object[] array = parser.getHeaderMap().keySet().toArray(new String[0]);
                return Arrays.equals(array, HEADERS);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

