/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.nmr.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.FilteredMeasurement;
import org.eclipse.chemclipse.nmr.model.core.AcquisitionParameter;
import org.eclipse.chemclipse.nmr.model.core.DataDimension;
import org.eclipse.chemclipse.nmr.model.core.FIDMeasurement;
import org.eclipse.chemclipse.nmr.model.core.FIDSignal;
import org.eclipse.chemclipse.processing.filter.FilterContext;

public class FilteredFIDMeasurement<ConfigType>
extends FilteredMeasurement<FIDMeasurement, ConfigType>
implements FIDMeasurement {
    private static final long serialVersionUID = -4499531764775929976L;
    private transient List<? extends FIDSignal> signals;

    public FilteredFIDMeasurement(FilterContext<FIDMeasurement, ConfigType> context) {
        super(context);
    }

    @Override
    public DataDimension getDataDimension() {
        return ((FIDMeasurement)this.getFilteredObject()).getDataDimension();
    }

    @Override
    public final AcquisitionParameter getAcquisitionParameter() {
        return ((FIDMeasurement)this.getFilteredObject()).getAcquisitionParameter();
    }

    @Override
    public List<? extends FIDSignal> getSignals() {
        if (this.signals != null) {
            return this.signals;
        }
        return ((FIDMeasurement)this.getFilteredObject()).getSignals();
    }

    public final void setSignals(List<? extends FIDSignal> signals) {
        this.signals = signals;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.signals == null) {
            out.writeObject(null);
        } else {
            ArrayList<FIDSignal> serList = new ArrayList<FIDSignal>(this.signals.size());
            for (FIDSignal fIDSignal : this.signals) {
                if (fIDSignal instanceof Serializable) {
                    serList.add(fIDSignal);
                    continue;
                }
                serList.add(new SerializableFIDSignal(fIDSignal));
            }
            out.writeObject(serList);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.signals = (List)in.readObject();
    }

    private static final class SerializableFIDSignal
    implements FIDSignal,
    Serializable {
        private static final long serialVersionUID = -2997689760733045361L;
        private BigDecimal signalTime;
        private Number realComponent;
        private Number imaginaryComponent;

        public SerializableFIDSignal(FIDSignal tocopy) {
            this.signalTime = tocopy.getSignalTime();
            this.realComponent = tocopy.getRealComponent();
            this.imaginaryComponent = tocopy.getImaginaryComponent();
        }

        @Override
        public BigDecimal getSignalTime() {
            return this.signalTime;
        }

        @Override
        public Number getRealComponent() {
            return this.realComponent;
        }

        @Override
        public Number getImaginaryComponent() {
            return this.imaginaryComponent;
        }
    }
}

