/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3D;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3DSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.ISelectionListenerPCs;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.PrincipalComponentUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedScorePlot3D
extends Composite {
    private ScorePlot3D plot;
    private PrincipalComponentUI principalComponentUI;
    private EvaluationPCA evaluationPCA = null;

    public ExtendedScorePlot3D(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(EvaluationPCA evaluationPCA) {
        this.evaluationPCA = evaluationPCA;
        this.updateWidgets();
        this.applySettings();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(this);
        this.plot = this.createPlot(this);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.principalComponentUI = this.createPrincipalComponentUI(composite);
        this.createSettingsButton(composite);
    }

    private ScorePlot3D createPlot(Composite parent) {
        ScorePlot3D plot = new ScorePlot3D(parent, 2048);
        return plot;
    }

    private PrincipalComponentUI createPrincipalComponentUI(Composite parent) {
        PrincipalComponentUI principalComponentUI = new PrincipalComponentUI(parent, 0);
        principalComponentUI.setSelectionListener(new ISelectionListenerPCs(){

            @Override
            public void update(int pcX, int pcY, int pcZ) {
                ExtendedScorePlot3D.this.updatePlot(pcX, pcY, pcZ);
            }
        });
        return principalComponentUI;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePage()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedScorePlot3D.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        int pcX = this.principalComponentUI.getPCX();
        int pcY = this.principalComponentUI.getPCY();
        int pcZ = this.principalComponentUI.getPCZ();
        this.updatePlot(pcX, pcY, pcZ);
    }

    private void updateWidgets() {
        if (this.evaluationPCA != null) {
            IAnalysisSettings analysisSettings = this.evaluationPCA.getSamples().getAnalysisSettings();
            this.principalComponentUI.setInput(analysisSettings);
        } else {
            this.principalComponentUI.setInput(null);
        }
    }

    private void updatePlot(int pcX, int pcY, int pcZ) {
        if (this.evaluationPCA != null) {
            ScorePlot3DSettings settings = this.plot.getSettings();
            settings.setPcX(pcX);
            settings.setPcX(pcY);
            settings.setPcX(pcZ);
            this.plot.setInput(this.evaluationPCA);
        } else {
            this.plot.setInput(null);
        }
    }
}

