/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class TableViewerFieldEditor<Value>
extends FieldEditor {
    private TableViewer tableViewer;
    private Composite buttonBox;
    private Button upButton;
    private Button downButton;
    private Button newButton;
    private Button removeButton;
    private String[] columnNames;
    private int[] columnWidth;
    private int sortColumn = 0;
    private int sortDirection = 0;

    protected TableViewerFieldEditor(String name, String labelText, String[] columnNames, int[] columnWidth, Composite parent) {
        this.columnNames = columnNames;
        this.columnWidth = columnWidth;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected abstract String createSavePreferences(List<Value> var1);

    protected abstract List<Value> parseSavePreferences(String var1);

    protected abstract String convertColumnValue(Value var1, int var2);

    protected abstract List<Value> getNewInputObject();

    protected abstract int compareValue(Value var1, Value var2, int var3);

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.tableViewer.getTable().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 500;
        gridData.heightHint = 200;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = this.getTableControl(composite);
        Table table = this.tableViewer.getTable();
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonControl(composite);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableViewerFieldEditor.this.sortColumn == index) {
                    if (TableViewerFieldEditor.this.tableViewer.getTable().getSortDirection() == 0) {
                        TableViewerFieldEditor.this.tableViewer.getTable().setSortDirection(1024);
                        TableViewerFieldEditor.this.sortDirection = 1;
                    } else if (TableViewerFieldEditor.this.tableViewer.getTable().getSortDirection() == 1024) {
                        TableViewerFieldEditor.this.tableViewer.getTable().setSortDirection(128);
                        TableViewerFieldEditor.this.sortDirection = -1;
                    } else {
                        TableViewerFieldEditor.this.tableViewer.getTable().setSortDirection(0);
                        TableViewerFieldEditor.this.sortDirection = 0;
                    }
                } else {
                    TableViewerFieldEditor.this.tableViewer.getTable().setSortDirection(1024);
                }
                TableViewerFieldEditor.this.sortColumn = index;
                TableViewerFieldEditor.this.tableViewer.getTable().setSortColumn(column);
                TableViewerFieldEditor.this.update();
            }
        };
        return selectionAdapter;
    }

    private void moveUp() {
        int index = this.tableViewer.getTable().getSelectionIndex();
        Value movedElement = this.getInput().remove(index);
        int newIndex = Math.min(index - 1, 0);
        this.getInput().add(newIndex, movedElement);
        this.update();
    }

    private void moveDown() {
        int index = this.tableViewer.getTable().getSelectionIndex();
        Value movedElement = this.getInput().remove(index);
        int newIndex = Math.max(index + 1, this.getInput().size());
        this.getInput().add(newIndex, movedElement);
        this.update();
    }

    private void addItem() {
        List<Value> values = this.getNewInputObject();
        for (Value value : values) {
            if (this.getInput().contains(value)) continue;
            this.getInput().add(value);
            this.update();
        }
    }

    protected Shell getShell() {
        return this.newButton.getShell();
    }

    private void removeItem() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        List selections = selection.toList();
        for (Object value : selections) {
            this.getInput().remove(value);
        }
        this.update();
    }

    private Composite getButtonControl(Composite parent) {
        Composite box = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        box.setLayout((Layout)layout);
        GridLayoutFactory.fillDefaults().applyTo(box);
        this.newButton = this.createButton(box, "New");
        this.newButton.addListener(13, e -> this.addItem());
        this.removeButton = this.createButton(box, "Remove");
        this.removeButton.addListener(13, e -> this.removeItem());
        this.upButton = this.createButton(box, "Up");
        this.upButton.addListener(13, e -> this.moveUp());
        this.downButton = this.createButton(box, "Down");
        this.downButton.addListener(13, e -> this.moveDown());
        return box;
    }

    private Button createButton(Composite box, String text) {
        Button button = new Button(box, 8);
        button.setText(text);
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return button;
    }

    private TableViewerColumn createColumn(TableViewer tableViewer, String name, int width, final int order) {
        TableViewerColumn culumn = new TableViewerColumn(tableViewer, 0);
        culumn.getColumn().setWidth(width);
        culumn.getColumn().setText(name);
        culumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return TableViewerFieldEditor.this.convertColumnValue(element, order);
            }
        });
        return culumn;
    }

    private TableViewer getTableControl(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 68354);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < this.columnNames.length) {
            TableViewerColumn column = this.createColumn(tableViewer, this.columnNames[i], this.columnWidth[i], i);
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(column.getColumn(), i));
            ++i;
        }
        tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerFieldEditor.this.update();
            }
        });
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return TableViewerFieldEditor.this.sortDirection * TableViewerFieldEditor.this.compareValue(e1, e2, TableViewerFieldEditor.this.sortColumn);
            }
        });
        return tableViewer;
    }

    protected void doLoad() {
        String preferences = this.getPreferenceStore().getString(this.getPreferenceName());
        List<Value> v = this.parseSavePreferences(preferences);
        this.tableViewer.setInput(v);
        this.update();
    }

    protected void doLoadDefault() {
        String preferences = this.getPreferenceStore().getString(this.getPreferenceName());
        List<Value> v = this.parseSavePreferences(preferences);
        this.tableViewer.setInput(v);
        this.update();
    }

    private void update() {
        int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        this.newButton.setEnabled(true);
        this.upButton.setEnabled(selectionIndex != -1 && selectionIndex > 0 && this.sortDirection == 0);
        this.downButton.setEnabled(selectionIndex != -1 && selectionIndex < this.tableViewer.getTable().getItemCount() - 1 && this.sortDirection == 0);
        this.removeButton.setEnabled(selectionIndex != -1);
        this.tableViewer.getTable().update();
        this.tableViewer.refresh();
    }

    protected void doStore() {
        List<Value> v = this.getInput();
        String store = this.createSavePreferences(v);
        this.getPreferenceStore().setValue(this.getPreferenceName(), store);
    }

    public List<Value> getDataTable() {
        return Collections.unmodifiableList(this.getInput());
    }

    private List<Value> getInput() {
        return (List)this.tableViewer.getInput();
    }

    public int getNumberOfControls() {
        return 2;
    }
}

