/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.fieldeditors;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends StringFieldEditor {
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;

    public DoubleFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public DoubleFieldEditor(String name, String labelText, double minValue, double maxValue, Composite parent) {
        super(name, labelText, parent);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    protected boolean checkState() {
        block4: {
            Text textControl = this.getTextControl();
            if (textControl == null) {
                return false;
            }
            String stringValue = textControl.getText();
            Double value = Double.valueOf(stringValue);
            if (!(value >= this.minValue) || !(value <= this.maxValue)) break block4;
            this.clearErrorMessage();
            return true;
        }
        try {
            this.setAndShowErrorMessage();
        }
        catch (NumberFormatException e) {
            this.setAndShowErrorMessage();
        }
        return false;
    }

    protected void doLoad() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            Double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            textControl.setText(value.toString());
        }
        super.doLoad();
    }

    protected void doLoadDefault() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            Double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            textControl.setText(value.toString());
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            double value = Double.valueOf(textControl.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), value);
        }
    }

    private void setAndShowErrorMessage() {
        this.showErrorMessage("Allowed range (MIN = " + this.minValue + ")(MAX = " + this.maxValue + ")");
    }
}

