/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.menu.TableMenuEntryComparator;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.IColumnMoveListener;
import org.eclipse.chemclipse.support.ui.swt.IExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.support.ui.swt.TableSettings;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedTableViewer
extends TableViewer
implements IExtendedTableViewer {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedTableViewer.class);
    private static final String MENU_TEXT = "Table PopUp Menu";
    private ITableSettings tableSettings = new TableSettings();
    private final List<TableViewerColumn> tableViewerColumns = new ArrayList<TableViewerColumn>();
    private final Map<String, Set<ITableMenuEntry>> categoryMenuEntriesMap = new HashMap<String, Set<ITableMenuEntry>>();
    private final Map<String, ITableMenuEntry> menuEntryMap = new HashMap<String, ITableMenuEntry>();
    private final Map<String, MenuManager> menuManagerMap = new HashMap<String, MenuManager>();
    private final Set<KeyListener> userDefinedKeyListeners = new HashSet<KeyListener>();
    private final List<IColumnMoveListener> columnMoveListeners = new ArrayList<IColumnMoveListener>();
    private boolean editEnabled;

    public ExtendedTableViewer(Composite parent) {
        this(parent, 66306);
    }

    public ExtendedTableViewer(Composite parent, int style) {
        super(parent, style);
        this.applySettings(this.tableSettings);
        this.editEnabled = true;
        this.registerMenuListener();
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    @Override
    public ITableSettings getTableSettings() {
        return this.tableSettings;
    }

    @Override
    public void applySettings(ITableSettings tableSettings) {
        this.tableSettings = tableSettings == null ? new TableSettings() : tableSettings;
        this.createKeyListener();
    }

    public void addColumnMoveListener(IColumnMoveListener columnMoveListener) {
        this.columnMoveListeners.add(columnMoveListener);
    }

    public void removeColumnMoveListener(IColumnMoveListener columnMoveListener) {
        this.columnMoveListeners.remove(columnMoveListener);
    }

    private void registerMenuListener() {
        this.getTable().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                if (ExtendedTableViewer.this.tableSettings.isCreateMenu()) {
                    ExtendedTableViewer.this.createPopupMenu();
                } else {
                    Menu menu = ExtendedTableViewer.this.getTable().getMenu();
                    if (menu != null) {
                        ExtendedTableViewer.this.getTable().setMenu(null);
                        menu.dispose();
                    }
                }
            }
        });
    }

    @Override
    public void createColumns(String[] titles, int[] bounds) {
        final Table table = this.getTable();
        table.setRedraw(false);
        this.tableViewerColumns.clear();
        table.clearAll();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        table.setRedraw(true);
        this.refresh();
        if (this.getLabelProvider() != null) {
            int i = 0;
            while (i < titles.length) {
                final int index = i;
                TableViewerColumn tableViewerColumn = this.createTableColumn(titles[i], bounds[i]);
                final TableColumn tableColumn = tableViewerColumn.getColumn();
                tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ExtendedTableViewer.this.sortColumn(table, index, tableColumn);
                    }
                });
                this.tableViewerColumns.add(tableViewerColumn);
                ++i;
            }
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected void sortColumn(Table table, int index, TableColumn tableColumn) {
        ViewerComparator viewerComparator = this.getComparator();
        IRecordTableComparator recordTableComparator = (IRecordTableComparator)Adapters.adapt((Object)viewerComparator, IRecordTableComparator.class);
        if (recordTableComparator != null) {
            recordTableComparator.setColumn(index);
            int direction = table.getSortDirection();
            direction = table.getSortColumn() == tableColumn ? (direction == 128 ? 1024 : 128) : 128;
            table.setSortDirection(direction);
            table.setSortColumn(tableColumn);
            this.refresh();
        }
    }

    private void fireColumnMoved() {
        for (IColumnMoveListener columnMoveListener : this.columnMoveListeners) {
            columnMoveListener.handle();
        }
    }

    @Override
    public List<TableViewerColumn> getTableViewerColumns() {
        return Collections.unmodifiableList(this.tableViewerColumns);
    }

    public TableViewerColumn getTableViewerColumn(String label) {
        for (TableViewerColumn tableViewerColumn : this.tableViewerColumns) {
            if (!tableViewerColumn.getColumn().getText().equals(label)) continue;
            return tableViewerColumn;
        }
        return null;
    }

    @Override
    public boolean isEditEnabled() {
        return this.editEnabled;
    }

    @Override
    public void setEditEnabled(boolean editEnabled) {
        this.editEnabled = editEnabled;
    }

    public boolean isColumnSelected(Event event, String columnLabel) {
        int i = 0;
        while (i < this.tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = this.tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.endsWith(columnLabel)) {
                return this.isColumnSelected(event, i);
            }
            ++i;
        }
        return false;
    }

    public boolean isColumnSelected(Event event, int columnIndex) {
        Table table = this.getTable();
        Rectangle clientArea = table.getClientArea();
        Point point = new Point(event.x, event.y);
        int index = table.getTopIndex();
        while (index < table.getItemCount()) {
            boolean visible = false;
            TableItem item = table.getItem(index);
            int i = 0;
            while (i < table.getColumnCount()) {
                Rectangle rectangle = item.getBounds(i);
                if (rectangle.contains(point) && i == columnIndex) {
                    return true;
                }
                if (!visible && rectangle.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                return false;
            }
            ++index;
        }
        return false;
    }

    private void createKeyListener() {
        Table table = this.getTable();
        for (KeyListener keyListener : this.userDefinedKeyListeners) {
            table.removeKeyListener(keyListener);
        }
        this.userDefinedKeyListeners.clear();
        final ExtendedTableViewer extendedTableViewer = this;
        for (final IKeyEventProcessor keyEventProcessor : this.tableSettings.getKeyEventProcessors()) {
            KeyAdapter keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    keyEventProcessor.handleEvent(extendedTableViewer, e);
                }
            };
            table.addKeyListener((KeyListener)keyListener);
            this.userDefinedKeyListeners.add((KeyListener)keyListener);
        }
    }

    private void createPopupMenu() {
        Table table = this.getTable();
        table.setMenu(null);
        this.categoryMenuEntriesMap.clear();
        this.menuEntryMap.clear();
        this.menuManagerMap.clear();
        String menuId = this.getClass().getCanonicalName();
        MenuManager menuManager = new MenuManager(MENU_TEXT, menuId);
        menuManager.setRemoveAllWhenShown(true);
        this.addMenuItemsFromChartSettings();
        this.createMenuItems(menuManager);
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private void addMenuItemsFromChartSettings() {
        for (ITableMenuEntry menuEntry : this.tableSettings.getMenuEntries()) {
            this.addMenuEntry(menuEntry);
        }
    }

    private void addMenuEntry(ITableMenuEntry menuEntry) {
        if (menuEntry != null) {
            String category = menuEntry.getCategory();
            Set<ITableMenuEntry> menuEntries = this.categoryMenuEntriesMap.get(category);
            if (menuEntries == null) {
                menuEntries = new HashSet<ITableMenuEntry>();
                this.categoryMenuEntriesMap.put(category, menuEntries);
            }
            menuEntries.add(menuEntry);
            this.menuEntryMap.put(menuEntry.getName(), menuEntry);
        }
    }

    private void createMenuItems(MenuManager menuManager) {
        ArrayList<String> categories = new ArrayList<String>(this.categoryMenuEntriesMap.keySet());
        Collections.sort(categories);
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            String category = (String)iterator.next();
            this.createMenuCategory(menuManager, category, this.categoryMenuEntriesMap.get(category));
            if (!iterator.hasNext()) continue;
            menuManager.add((IContributionItem)new Separator());
        }
    }

    private void createMenuCategory(MenuManager menuManager, final String category, Set<ITableMenuEntry> tableMenuEntries) {
        ArrayList<ITableMenuEntry> menuEntries = new ArrayList<ITableMenuEntry>(tableMenuEntries);
        Collections.sort(menuEntries, new TableMenuEntryComparator());
        for (final ITableMenuEntry menuEntry : menuEntries) {
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    if ("".equals(category)) {
                        manager.add(ExtendedTableViewer.this.getAction(menuEntry));
                    } else {
                        MenuManager subMenu = (MenuManager)ExtendedTableViewer.this.menuManagerMap.get(category);
                        if (subMenu == null) {
                            subMenu = new MenuManager(category, null);
                            ExtendedTableViewer.this.menuManagerMap.put(category, subMenu);
                            manager.add((IContributionItem)subMenu);
                        }
                        subMenu.add(ExtendedTableViewer.this.getAction(menuEntry));
                    }
                }
            });
        }
    }

    private IAction getAction(final ITableMenuEntry menuEntry) {
        final ExtendedTableViewer extendedTableViewer = this;
        Action action = new Action(){

            public void run() {
                menuEntry.execute(extendedTableViewer);
            }
        };
        action.setText(menuEntry.getName());
        return action;
    }

    @Override
    public void clearColumns() {
        this.tableViewerColumns.clear();
        Table table = this.getTable();
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
    }

    @Override
    public <D, C> TableViewerColumn addColumn(final ColumnDefinition<D, C> definition) {
        TableViewerColumn tableViewerColumn = ControlBuilder.createColumn(this, definition, this.editEnabled);
        tableViewerColumn.getColumn().setMoveable(true);
        tableViewerColumn.getColumn().addListener(10, new Listener(){

            public void handleEvent(Event event) {
                ExtendedTableViewer.this.fireColumnMoved();
            }
        });
        this.tableViewerColumns.add(tableViewerColumn);
        final Comparator<C> comparator = definition.getComparator();
        if (comparator != null) {
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Table table = ExtendedTableViewer.this.getTable();
                    final int direction = table.getSortColumn() == tableColumn ? (table.getSortDirection() == 128 ? 1024 : 128) : 128;
                    ExtendedTableViewer.this.setComparator(new ViewerComparator(){

                        public void sort(Viewer viewer, Object[] elements) {
                            Comparator<Object> comparer = new Comparator<Object>(){

                                @Override
                                public int compare(Object o1, Object o2) {
                                    Object d2;
                                    Object d1;
                                    block6: {
                                        block5: {
                                            try {
                                                d1 = definition.apply(o1);
                                                d2 = definition.apply(o2);
                                                if (d1 != null) break block5;
                                                if (d2 == null) {
                                                    return 0;
                                                }
                                                return 1;
                                            }
                                            catch (ClassCastException e) {
                                                LOG.warn("Inconsitent data items in respect to column definition: {}, sorting will be inconsistent!", (Object)e.toString());
                                                return 0;
                                            }
                                        }
                                        if (d2 != null) break block6;
                                        return -1;
                                    }
                                    return comparator.compare(d1, d2);
                                }
                            };
                            if (direction == 1024) {
                                comparer = Collections.reverseOrder(comparer);
                            }
                            Arrays.sort(elements, comparer);
                        }
                    });
                    table.setSortDirection(direction);
                    table.setSortColumn(tableColumn);
                    ExtendedTableViewer.this.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        return tableViewerColumn;
    }

    private TableViewerColumn createTableColumn(String title, int width) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(title);
        tableColumn.setWidth(width);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                ExtendedTableViewer.this.fireColumnMoved();
            }
        });
        return tableViewerColumn;
    }
}

