/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.ChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.IChromatogramIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.IChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.NoIntegratorAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramIntegratorProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Integrator";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            ArrayList list = new ArrayList();
            IChromatogramIntegratorSupport support = ChromatogramIntegrator.getChromatogramIntegratorSupport();
            for (String processorId : support.getAvailableIntegratorIds()) {
                IChromatogramIntegratorSupplier supplier = support.getIntegratorSupplier(processorId);
                list.add((IProcessSupplier<?>)new ChromatogramIntegratorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIntegratorAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramIntegratorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramIntegrationSettings> {
        public ChromatogramIntegratorProcessorSupplier(IChromatogramIntegratorSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getIntegratorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD, DataType.WSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramIntegrationSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (processSettings instanceof IChromatogramIntegrationSettings) {
                messageConsumer.addMessages(ChromatogramIntegrator.integrate(chromatogramSelection, processSettings, this.getId(), monitor));
            } else {
                messageConsumer.addMessages(ChromatogramIntegrator.integrate(chromatogramSelection, this.getId(), monitor));
            }
            return chromatogramSelection;
        }
    }
}

